/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.enterprise.deploy.shared;

/**
 * Class CommandTypes defines enumeration values for the 
 * DeploymentStatus object.
 *
 * @author  rsearls
 */
public class CommandType
{
	private int value; // This enumeration value's int value

	/**
     * The DeploymentManger action operation being processed
     * is distribute.
     */
	public static final CommandType DISTRIBUTE = new CommandType(0);
	/**
     * The DeploymentManger action operation being processed is start.
     */
    public static final CommandType START = new CommandType(1);
	/**
     * The DeploymentManger action operation being processed is stop.
     */
    public static final CommandType STOP = new CommandType(2);
	/**
     * The DeploymentManger action operation being processed is undeploy.
     */
    public static final CommandType UNDEPLOY = new CommandType(3);
	/**
     * The DeploymentManger action operation being processed is redeploy.
     */
    public static final CommandType REDEPLOY = new CommandType(4);


	private static final String[] stringTable = {
	"distribute",
	"start",
	"stop",
	"undeploy",
	"redeploy",
	};

	private static final CommandType[] enumValueTable = {
	DISTRIBUTE,
	START,
	STOP,
	UNDEPLOY,
	REDEPLOY,
	};
    
    /**
     * Construct a new enumeration value with the given integer value.
     *
     * @param  value  Integer value.
     */
    protected CommandType(int value) 
    {
		this.value = value;
    }
       
    /**
     * Returns this enumeration value's integer value.
     * @return the value
     */
    public int getValue()
    {   return value;
    }

	/**
	 * Returns the string table for class CommandType
	 */
	protected String[] getStringTable()
	{
		return stringTable;
	}

	/**
	 * Returns the enumeration value table for class CommandType
	 */
	protected CommandType[] getEnumValueTable()
	{
		return enumValueTable;
	}

    /**
     * Return an object of the specified value.
     * @param value a designator for the object.
     */
    public static CommandType getCommandType(int value)
    {   return enumValueTable[value];
    }

    /**
     * Return the string name of this CommandType or the
     * integer value if outside the bounds of the table
     */
    public String toString()
    {
        String[] strTable = getStringTable();
        int index = value - getOffset();
        if (strTable != null && index >= 0 && index < strTable.length)
            return strTable[index];
        else
            return Integer.toString (value);
    }

    /**
     * Returns the lowest integer value used by this enumeration value's
     * enumeration class.
     * <P>
     * The default implementation returns 0.
     * @return the offset of the lowest enumeration value.
     */
    protected int getOffset()
    {   return 0;
    }

}
