/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.changesets;

import java.util.Hashtable;
import java.util.Vector;

/**
 * <p>
 * <b>Purpose</b>: Provide public API to the OrderedCollectionChangeRecord.
 * <p>
 * <b>Description</b>: OrderedCollections, used in TopLink SDK, must be tracked differently from regulat Collections.
 * As the objects in the collection have a particular index which must be stored. This class stores the objects which must be written
 * into the collection and the indexes they must be written in at.  Inserting a new element at the beginning of the list will result
 * in the intire list being stored in the change set as the index of all other objects has changed.  Everything after the remove index will
 * be remove.
 */
public interface OrderedCollectionChangeRecord extends ChangeRecord {

    /**
     * ADVANCED:
     * This method returns the collection of indexes in which changes were made to this collection.
     * @return java.util.Vector
     */
    public Vector getAddIndexes();

    /**
     * ADVANCED:
     * This method returns the collection of ChangeSets that were added to the collection.
     * The indexes of these objects are the Keys of the Hashtable
     * @return java.util.Hashtable
     */
    public Hashtable getAddObjectList();

    /**
     * ADVANCED:
     * This method returns the index from where objects must be removed from the collection
     * @return int
     */
    public int getStartRemoveIndex();
}
