/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.config;

/**
 * Cache usage hint values.
 * 
 * The class contains all the valid values for TopLinkQueryHints.CACHE_USAGE query hint.
 * 
 * JPA Query Hint Usage:
 * 
 * query.setHint(TopLinkQueryHints.CACHE_USAGE, CacheUsage.CheckCacheOnly);
 * or 
 * @QueryHint(name=TopLinkQueryHints.CACHE_USAGE, value=CacheUsage.CheckCacheOnly)
 * 
 * Hint values are case-insensitive.
 * "" could be used instead of default value CacheUsage.DEFAULT.
 * 
 * @see TopLinkQueryHints
 */
public class CacheUsage {
    public static final String  UseEntityDefault = "UseEntityDefault";
    public static final String  DoNotCheckCache = "DoNotCheckCache";
    public static final String  CheckCacheByExactPrimaryKey = "CheckCacheByExactPrimaryKey";
    public static final String  CheckCacheByPrimaryKey = "CheckCacheByPrimaryKey";
    public static final String  CheckCacheThenDatabase = "CheckCacheThenDatabase";
    public static final String  CheckCacheOnly = "CheckCacheOnly";
    public static final String  ConformResultsInUnitOfWork = "ConformResultsInUnitOfWork";
 
    public static final String DEFAULT = UseEntityDefault;
}
