/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.util.HashMap;

import oracle.toplink.essentials.logging.SessionLog;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;

/**
 * Logger class for the metadata processors. It defines the common log messages 
 * used by the metadata processors.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataLogger  {
    public static final String ALIAS = "metadata_default_alias";
    public static final String MAP_KEY_ATTRIBUTE_NAME = "metadata_default_map_key_attribute_name";
    public static final String IGNORE_BASIC_FETCH_LAZY = "annotation_warning_ignore_basic_fetch_lazy";
    public static final String IGNORE_GET_METHOD = "annotation_warning_ignore_get_method";
    public static final String IGNORE_SECONDARY_TABLE = "annotation_warning_ignore_secondary_table";
    
    public static final String TABLE_NAME = "metadata_default_table_name"; 
    public static final String TABLE_SCHEMA = "metadata_default_table_schema";
    public static final String TABLE_CATALOG = "metadata_default_table_catalog";
    
    public static final String JOIN_TABLE_NAME = "metadata_default_join_table_name";
    public static final String JOIN_TABLE_SCHEMA = "metadata_default_join_table_schema";
    public static final String JOIN_TABLE_CATALOG = "metadata_default_join_table_catalog";
    
    public static final String COLUMN = "metadata_default_column";
    public static final String PK_COLUMN = "metadata_default_pk_column";
    public static final String FK_COLUMN = "metadata_default_fk_column";
    public static final String SOURCE_PK_COLUMN = "metadata_default_source_pk_column";
    public static final String SOURCE_FK_COLUMN = "metadata_default_source_fk_column";
    public static final String TARGET_PK_COLUMN = "metadata_default_target_pk_column";
    public static final String TARGET_FK_COLUMN = "metadata_default_target_fk_column";
    public static final String DISCRIMINATOR_COLUMN = "metadata_default_discriminator_column";
    public static final String INHERITANCE_PK_COLUMN = "metadata_default_inheritance_pk_column";
    public static final String INHERITANCE_FK_COLUMN = "metadata_default_inheritance_fk_column";
    public static final String SECONDARY_TABLE_PK_COLUMN = "metadata_default_secondary_table_pk_column";
    public static final String SECONDARY_TABLE_FK_COLUMN = "metadata_default_secondary_table_fk_column";
    
    public static final String ONE_TO_ONE_MAPPING = "metadata_default_one_to_one_mapping";
    public static final String ONE_TO_MANY_MAPPING = "metadata_default_one_to_many_mapping";
    public static final String ONE_TO_ONE_MAPPING_REFERENCE_CLASS = "metadata_default_one_to_one_reference_class";
    public static final String ONE_TO_MANY_MAPPING_REFERENCE_CLASS = "metadata_default_one_to_many_reference_class";
    public static final String MANY_TO_ONE_MAPPING_REFERENCE_CLASS = "metadata_default_many_to_one_reference_class";
    public static final String MANY_TO_MANY_MAPPING_REFERENCE_CLASS = "metadata_default_many_to_many_reference_class";
    
    // Shared context strings that are defined by the subclasses.
    public static String IGNORE_TABLE;
    public static String IGNORE_QUERY;
    public static String IGNORE_MAPPING;
    public static String IGNORE_ID_CLASS;
    public static String IGNORE_PRIMARY_KEY;
    public static String IGNORE_EMBEDDED_ID;
    public static String IGNORE_INHERITANCE;
    public static String IGNORE_VERSION_LOCKING;
    
    protected AbstractSession session; 
    protected HashMap ctxStrings;

    public MetadataLogger(AbstractSession session) {
        this.session = session;
        ctxStrings = new HashMap();
        initSharedContextStrings();
        populateContextStrings();
    }
    
    /**
     * INTERNAL:
	 * Return the logging context string for the given context.
     */
	protected String getLoggingContextString(String context) {
        return (String) ctxStrings.get(context);
	}  
    
    /**
     * INTERNAL:
     * Init the shared context strings.
     */
    protected void initSharedContextStrings() {
        IGNORE_TABLE = "annotation_warning_ignore_table";
        IGNORE_QUERY = "annotation_warning_ignore_query";
        IGNORE_MAPPING = "annotation_warning_ignore_mapping";
        IGNORE_ID_CLASS = "annotation_warning_ignore_id_class";
        IGNORE_PRIMARY_KEY = "annotation_warning_ignore_primary_key";
        IGNORE_EMBEDDED_ID = "annotation_warning_ignore_embedded_id";
        IGNORE_INHERITANCE = "annotation_warning_ignore_inheritance";
        IGNORE_VERSION_LOCKING = "annotation_warning_ignore_version_locking";
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void log(int level, String ctx, Object[] params) {
        session.log(level, SessionLog.EJB_ANNOTATION, getLoggingContextString(ctx), params);
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logConfigMessage(String ctx, MetadataAccessor accessor, Object param) {
        log(SessionLog.CONFIG, ctx, new Object[] { accessor.getAnnotatedElement(), param });
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logConfigMessage(String ctx, MetadataDescriptor md, Object param) {
        log(SessionLog.CONFIG, ctx, new Object[] { md.getJavaClass(), param });
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logConfigMessage(String ctx, Object object) {
        log(SessionLog.CONFIG, ctx, new Object[] { object });    
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logConfigMessage(String ctx, Object param1, Object param2) {
        log(SessionLog.CONFIG, ctx, new Object[] { param1, param2 });    
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logWarningMessage(String ctx, MetadataAccessor accessor) {
        log(SessionLog.WARNING, ctx, new Object[] { accessor.getJavaClass(), accessor.getAttributeName() });
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logWarningMessage(String ctx, Object param) {
        log(SessionLog.WARNING, ctx, new Object[] { param });    
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logWarningMessage(String ctx, Object param1, Object param2) {
        log(SessionLog.WARNING, ctx, new Object[] { param1, param2 });    
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void logWarningMessage(String ctx, Object param1, Object param2, Object param3) {
        log(SessionLog.WARNING, ctx, new Object[] {param1, param2, param3});
    }
    
    /**
     * INTERNAL:
	 * Method will populate the common logging strings. Subclasses can add
     * to this by implementing this method. Just be sure to call this method
     * from the subclass to get the common strings.
     */
	protected void populateContextStrings() {
        ctxStrings.put(ALIAS, ALIAS);
        ctxStrings.put(MAP_KEY_ATTRIBUTE_NAME, MAP_KEY_ATTRIBUTE_NAME);
        
        ctxStrings.put(TABLE_NAME, TABLE_NAME);
        ctxStrings.put(TABLE_SCHEMA, TABLE_SCHEMA);
        ctxStrings.put(TABLE_CATALOG, TABLE_CATALOG);
        
        ctxStrings.put(JOIN_TABLE_NAME, JOIN_TABLE_NAME);
        ctxStrings.put(JOIN_TABLE_SCHEMA, JOIN_TABLE_SCHEMA);
        ctxStrings.put(JOIN_TABLE_CATALOG, JOIN_TABLE_CATALOG);
    
        ctxStrings.put(COLUMN, COLUMN);
        ctxStrings.put(PK_COLUMN, PK_COLUMN);
        ctxStrings.put(FK_COLUMN, FK_COLUMN);
        ctxStrings.put(SOURCE_PK_COLUMN, SOURCE_PK_COLUMN);
        ctxStrings.put(SOURCE_FK_COLUMN, SOURCE_FK_COLUMN);
        ctxStrings.put(TARGET_PK_COLUMN, TARGET_PK_COLUMN);
        ctxStrings.put(TARGET_FK_COLUMN, TARGET_FK_COLUMN);
        ctxStrings.put(DISCRIMINATOR_COLUMN, DISCRIMINATOR_COLUMN);
        ctxStrings.put(INHERITANCE_PK_COLUMN, INHERITANCE_PK_COLUMN);
        ctxStrings.put(INHERITANCE_FK_COLUMN, INHERITANCE_FK_COLUMN);
        ctxStrings.put(SECONDARY_TABLE_PK_COLUMN, SECONDARY_TABLE_PK_COLUMN);
        ctxStrings.put(SECONDARY_TABLE_FK_COLUMN, SECONDARY_TABLE_FK_COLUMN);
        
        ctxStrings.put(ONE_TO_ONE_MAPPING, ONE_TO_ONE_MAPPING);
        ctxStrings.put(ONE_TO_MANY_MAPPING, ONE_TO_MANY_MAPPING);
        ctxStrings.put(ONE_TO_ONE_MAPPING_REFERENCE_CLASS, ONE_TO_ONE_MAPPING_REFERENCE_CLASS);
        ctxStrings.put(ONE_TO_MANY_MAPPING_REFERENCE_CLASS, ONE_TO_MANY_MAPPING_REFERENCE_CLASS);
        ctxStrings.put(MANY_TO_ONE_MAPPING_REFERENCE_CLASS, MANY_TO_ONE_MAPPING_REFERENCE_CLASS);
        ctxStrings.put(MANY_TO_MANY_MAPPING_REFERENCE_CLASS, MANY_TO_MANY_MAPPING_REFERENCE_CLASS);
        
        ctxStrings.put(IGNORE_GET_METHOD, IGNORE_GET_METHOD);
        ctxStrings.put(IGNORE_SECONDARY_TABLE, IGNORE_SECONDARY_TABLE);
        
        ctxStrings.put(IGNORE_TABLE, IGNORE_TABLE);
        ctxStrings.put(IGNORE_QUERY, IGNORE_QUERY);
        ctxStrings.put(IGNORE_MAPPING, IGNORE_MAPPING);
        ctxStrings.put(IGNORE_ID_CLASS, IGNORE_ID_CLASS);
        ctxStrings.put(IGNORE_PRIMARY_KEY, IGNORE_PRIMARY_KEY);
        ctxStrings.put(IGNORE_EMBEDDED_ID, IGNORE_EMBEDDED_ID);
        ctxStrings.put(IGNORE_INHERITANCE, IGNORE_INHERITANCE);
        ctxStrings.put(IGNORE_VERSION_LOCKING, IGNORE_VERSION_LOCKING);
        ctxStrings.put(IGNORE_BASIC_FETCH_LAZY, IGNORE_BASIC_FETCH_LAZY);
        
    }
    
    /**
     * INTERNAL:
     * Set the session to log to.
     */
    public void setSession(AbstractSession session) {
        this.session = session;
    }
}
