/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing;

import java.util.List;
import java.util.ArrayList;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLAccessor;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;

/**
 * Object to hold onto an xml table generator metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLTableGenerator extends MetadataTableGenerator {
    protected Node m_node;
    protected XMLAccessor m_accessor;
    
    /**
     * INTERNAL:
     */
    public XMLTableGenerator(Node node, XMLAccessor accessor) {
        super(accessor.getDocumentName());
        
        m_node = node;
        m_accessor = accessor;
    }
    
    /**
     * INTERNAL:
     */
    public int getAllocationSize() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_ALLOCATION_SIZE, 50);
    }
    
    /**
     * INTERNAL:
     */
    public String getCatalog() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_CATALOG, m_accessor.getCatalog());
    }
    
    /**
     * INTERNAL:
     */
    public int getInitialValue() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_INITIAL_VALUE, 0);
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_NAME);
    }
    
    /**
     * INTERNAL:
     */
    public String getPkColumnName() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_PK_COLUMN_NAME);
    }
    
    /**
     * INTERNAL:
     */
    public String getPkColumnValue() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_PK_COLUMN_VALUE);
    }
    
    /**
     * INTERNAL:
     */
    public String getSchema() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_SCHEMA, m_accessor.getSchema());
    }
    
    /**
     * INTERNAL:
     */
    public String getTable() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_TABLE);
    }
    
    /**
     * INTERNAL:
     */
    public List<String> getUniqueConstraints() {
        if (m_uniqueConstraints == null) {
            m_uniqueConstraints = new ArrayList<String>();
            NodeList uniqueConstraintNodes = m_accessor.getHelper().getNodes(m_node, XMLConstants.UNIQUE_CONSTRAINTS);
        
            if (uniqueConstraintNodes != null) {
                for (int i = 0; i < uniqueConstraintNodes.getLength(); i++) {
                    NodeList columnNameNodes = m_accessor.getHelper().getTextColumnNodes(uniqueConstraintNodes.item(i));
                
                    if (columnNameNodes != null) {
                        for (int k = 0; k < columnNameNodes.getLength(); k++) {
                            String columnName = columnNameNodes.item(k).getNodeValue();
                        
                            if (columnName != null && !columnName.equals("")) {
                                m_uniqueConstraints.add(columnName);
                            }
                        }
                    }
                }
            }
        }
        
        return m_uniqueConstraints;
    }
    
    /**
     * INTERNAL:
     */
    public String getValueColumnName() {
        return m_accessor.getHelper().getNodeValue(m_node, XMLConstants.ATT_VALUE_COLUMN_NAME);
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromAnnotations() {
       return false; 
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
       return true; 
    }
}
