/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.helper;

/**
 * <p>
 * <b>Purpose</b>: Extension to the existing conversion manager to support the
 * EJB 3.0 spec. 
 * <p>
 * <b>Responsibilities</b>:
 * <ul>
 * <li> Allow a null value default to be read into primitives. With the current
 * conversion manager, setting a null into a primitive causes and exception. 
 * This conversion manager was added to avoid that exception and therefore, add 
 * support for schemas that were built before the object model was mapped 
 * (using a primitive). Therefore, TopLink will not change the null column value 
 * in the database through this conversion. The value on the dataabse will only 
 * be changed if the user actually sets a new primitive value.
 * <li> Allows users to define their own set of default null values to be used
 * in the conversion.
 * </ul>
 * 
 * @author Guy Pelletier
 * @since TopLink 10.1.4 RI
 */
public class EJB30ConversionManager extends ConversionManager {
    public EJB30ConversionManager() {
        super();
    }

    /**
     * INTERNAL:
     */
    public Object getDefaultNullValue(Class theClass) {
        Object defaultNullValue = getDefaultNullValues().get(theClass);
        
        if (defaultNullValue == null && theClass.isPrimitive()) {
            return 0;
        } else {
            return defaultNullValue;
        }
    }
}
