/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.helper;

import oracle.toplink.essentials.mappings.DatabaseMapping;

/**
 * INTERNAL:
 * Use to Sort The mappings in Descriptor, Mappings are either DirectToField, which must be at the top
 * or other
 * Avoid using this class as sun.misc is not part of many VM's like Netscapes.
 *
 */
public class MappingCompare implements TOPComparison {
    public int compare(Object arg1, Object arg2) {
        int arg1Value = ((DatabaseMapping)arg1).getWeight().intValue();
        int arg2Value = ((DatabaseMapping)arg2).getWeight().intValue();
        return (arg1Value - arg2Value);
    }
}
