/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.helper;


/**
 * INTERNAL:
 */
public class TOPSort {
    public TOPSort() {
    }

    public static void quicksort(Object[] arrayToSort, int left, int right, TOPComparison compareOperator) {
        if (left >= right) {
            return;
        }
        swapElements(arrayToSort, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; i++) {
            if (compareOperator.compare(arrayToSort[i], arrayToSort[left]) < 0) {
                swapElements(arrayToSort, ++last, i);
            }
        }
        swapElements(arrayToSort, left, last);
        quicksort(arrayToSort, left, last - 1, compareOperator);
        quicksort(arrayToSort, last + 1, right, compareOperator);
    }

    public static void quicksort(Object[] arrayToSort, TOPComparison compareOperator) {
        quicksort(arrayToSort, 0, arrayToSort.length - 1, compareOperator);
    }

    protected static void swapElements(Object[] arrayToSort, int index1, int index2) {
        Object tempIndex = arrayToSort[index1];
        arrayToSort[index1] = arrayToSort[index2];
        arrayToSort[index2] = tempIndex;
    }
}
