/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.queryframework;


/**
 * <p><b>Purpose</b>:
 * Used to provide the user with a means of contoling the behaviour of in memory queries
 * that access un-instantiated indirection in the query..
 *
 * <p><b>Description</b>:
 *      This class contains a state variable that is used to determine what a query should do
 * when accesing un-instantiated indirection.  Use use this policy access the policy of a query
 * set the policy behaviour using the methods below.  All read queries have the policy set to throw exception by default
 *
 * @author Gordon Yorke
 * @since TopLink/Java 3.6.3
 */
public class InMemoryQueryIndirectionPolicy implements java.io.Serializable {
    public static final int SHOULD_THROW_INDIRECTION_EXCEPTION = 0;
    public static final int SHOULD_TRIGGER_INDIRECTION = 1;
    public static final int SHOULD_IGNORE_EXCEPTION_RETURN_CONFORMED = 2;
    public static final int SHOULD_IGNORE_EXCEPTION_RETURN_NOT_CONFORMED = 3;
    protected int policy;

    public InMemoryQueryIndirectionPolicy() {
        this.policy = SHOULD_THROW_INDIRECTION_EXCEPTION;
    }

    public InMemoryQueryIndirectionPolicy(int policyValue) {
        this.policy = policyValue;
    }

    public boolean shouldTriggerIndirection() {
        return this.policy == SHOULD_TRIGGER_INDIRECTION;
    }

    public boolean shouldThrowIndirectionException() {
        return this.policy == SHOULD_THROW_INDIRECTION_EXCEPTION;
    }

    public boolean shouldIgnoreIndirectionExceptionReturnConformed() {
        return this.policy == SHOULD_IGNORE_EXCEPTION_RETURN_CONFORMED;
    }

    public boolean shouldIgnoreIndirectionExceptionReturnNotConformed() {
        return this.policy == SHOULD_IGNORE_EXCEPTION_RETURN_NOT_CONFORMED;
    }

    public void ignoreIndirectionExceptionReturnNotConformed() {
        this.policy = SHOULD_IGNORE_EXCEPTION_RETURN_NOT_CONFORMED;
    }

    public void ignoreIndirectionExceptionReturnConformed() {
        this.policy = SHOULD_IGNORE_EXCEPTION_RETURN_CONFORMED;
    }

    public void triggerIndirection() {
        this.policy = SHOULD_TRIGGER_INDIRECTION;
    }

    public void throwIndirectionException() {
        this.policy = SHOULD_THROW_INDIRECTION_EXCEPTION;
    }

    //feature 2297
    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
    }
}
