#
# The contents of this file are subject to the terms 
# of the Common Development and Distribution License 
# (the License).  You may not use this file except in
# compliance with the License.
# 
# You can obtain a copy of the license at 
# https://glassfish.dev.java.net/public/CDDLv1.0.html or
# glassfish/bootstrap/legal/CDDLv1.0.txt.
# See the License for the specific language governing 
# permissions and limitations under the License.
# 
# When distributing Covered Code, include this CDDL 
# Header Notice in each file and include the License file 
# at glassfish/bootstrap/legal/CDDLv1.0.txt.  
# If applicable, add the following below the CDDL Header, 
# with the fields enclosed by brackets [] replaced by
# you own identifying information: 
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
#

# defines for Java build
ifndef JAVAC
JAVAC       = $(EXTERNAL_JDK_DIR)/bin/javac
endif
ifndef JAVAH
JAVAH       = $(EXTERNAL_JDK_DIR)/bin/javah
endif
ifndef JAR
JAR         = $(EXTERNAL_JDK_DIR)/bin/jar
endif
ifndef JAVADOC
JAVADOC     = $(EXTERNAL_JDK_DIR)/bin/javadoc
endif

ifneq ($(OS_ARCH),WINNT)
CUR_DIR=$(shell pwd)
else
# PWD on NT appends CRLF which we must strip:
CUR_DIR=$(shell pwd | $(TR) -d "\r\n")
endif

#
# defs for ant
#

ANT_JAVA_HOME=$(CUR_DIR)/$(EXTERNAL_JDK_DIR)
ANT_HOME=$(CUR_DIR)/$(EXTERNAL_BASE)/ant/$(OBJDIR_NAME)

ifeq ($(OS_ARCH),WINNT)
ANT_BIN=ant.bat
else
ANT_BIN=ant
endif

ifndef ANT_BUILD_FILE
ANT_BUILD_FILE = build.xml
endif

STD_ANT_OPTIONS  = -buildfile $(ANT_BUILD_FILE)
STD_ANT_OPTIONS += -Djava.obj.dir=$(OBJDIR_NAME)

ifeq ($(BUILD_VARIANT), OPTIMIZED)
STD_ANT_OPTIONS += -Ddebug=off -Doptimize=on
else
STD_ANT_OPTIONS += -Ddebug=on -Doptimize=off
endif

_ANT_OPTIONS=$(STD_ANT_OPTIONS) $(ANT_OPTIONS)

ifndef ANT_TARGETS
ANT_TARGETS=all
endif

# Variable containing environment value for running ant
ANT_ENV=JAVA_HOME=$(ANT_JAVA_HOME) ANT_HOME=$(ANT_HOME) ANT_OPTS=-Xmx256m

# Ant command line
# (ANT_ARGS are optional and are specified by the user on the command line)
ANT=$(ANT_HOME)/bin/$(ANT_BIN) $(_ANT_OPTIONS) $(ANT_TARGETS)

# Ant clobber command
ANT_CLOBBER=$(MAKE) MAKEFLAGS='$(MAKEFLAGS)' $(ANT_ENV) ANT_TARGETS=clobber antit
