/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.common.util;

import java.util.AbstractCollection;
import java.util.ArrayList;

public class ContainerHelper
{
	///////////////////////////////////////////////////////////////////////////////////////////////////////

	public static String[] toStringArray(AbstractCollection coll) throws ArrayStoreException
	{
		String ss[] = new String[0];

		if(coll.size() > 0)
			ss = (String[]) coll.toArray(ss);

		return ss;
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////

	public static ArrayList toArrayList(String[] ss)
	{
		if(ss == null)
			return new ArrayList();

		ArrayList list = new ArrayList(ss.length);

		for(int i = 0; i < ss.length; i++)
			list.add(ss[i]);

		return list;
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////

	public static String toOneString(String[] ss)
	{
		String s = new String();
		
		for(int i = 0; ss != null && i < ss.length; i++)
		{
			s += ss[i] + "\n";//NOI18N
		}
		return s;
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	
	public static void main(String[] args)
	{
		ArrayList L1 = new ArrayList();
		ArrayList L2 = new ArrayList();

		L1.add("Hello");//NOI18N
		L1.add("World");//NOI18N
		L1.add("!!!");//NOI18N
		L2.add(new Integer(5));
		L2.add(new Integer(7));

		String ss[] = toStringArray(L1);

		for(int i = 0; i < ss.length; i++)
			System.out.println("String #" + i + ":  " + ss[i]);//NOI18N
		
		// should throw 
		try
		{
			ss = toStringArray(L2);
		}
		catch(ArrayStoreException e)
		{
			System.out.println("Caught an Exception, as expected:  " + e);//NOI18N
		}
	}
}

