/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LBCluster.java
 *
 * Created on June 21, 2004, 4:53 PM
 */

package com.sun.enterprise.tools.upgrade.cluster;
/**
 * This class represents a cluster element in loadbalancer
 *
 * @author  prakash
 */
import java.util.*;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LBCluster {
    
    private List instances;
    private List webModules;
    private LBHealthChecker healthChecker;
    /** Creates a new instance of LBCluster */
    public LBCluster(Element clusterElement) {
        instances = new ArrayList();
        webModules = new ArrayList();
        NodeList inEles = clusterElement.getElementsByTagName("instance");
        for(int lh =0; lh < inEles.getLength(); lh++){
            instances.add(new LBInstance((Element)inEles.item(lh)));
        }
        NodeList webEles = clusterElement.getElementsByTagName("web-module");
        for(int ih =0; ih < webEles.getLength(); ih++){
            webModules.add(new LBWebModule((Element)webEles.item(ih)));
        }
        NodeList helEles = clusterElement.getElementsByTagName("health-checker");
        for(int ih =0; ih < helEles.getLength(); ih++){
            // There should either zero or one health-checker.
            healthChecker = new LBHealthChecker((Element)helEles.item(ih));
        }
    }
    
    public LBHealthChecker getHealthChecker() {
        return healthChecker;
    }
    public java.util.List getInstances() {
        return instances;
    }
    public java.util.List getWebModules() {
        return webModules;
    }    
}
