/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SunACCTransfer.java
 *
 * Created on September 8, 2003, 2:08 PM
 */

package com.sun.enterprise.tools.upgrade.miscconfig;

/**
 *
 * @author  prakash
 */
import java.io.*;
import java.util.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;

public class SunACCTransfer {
    
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();
    private String docType = null;
    private String secPolicyProperty = null;
    /** Creates a new instance of SunACCTransfer */
    public SunACCTransfer() {
    }
    public void transform(String sourceFileName, String targetFileName){
        logger.log(Level.INFO, stringManager.getString("upgrade.configTransfers.sunacc.startMessage"));
        File sourceFile = new File(sourceFileName);
        File targetFile = new File(targetFileName);
        try {
            docType = this.getDOCTYPEString(targetFile);
            secPolicyProperty = this.getSecurityConfigValue(targetFile);
        } catch(Exception e) {}
        
        boolean renamed = targetFile.renameTo(new File(targetFileName+".bak"));
        if(!renamed){
            // This is possible if user is running the upgrade again and .bak is already created.
            renamed = targetFile.delete();
        }
        if(renamed){
            try{
                targetFile = new File(targetFileName);
                targetFile.createNewFile();
                this.transferFileContents(sourceFile, targetFile);
            }catch(Exception ex){
                // Log error message
                logger.log(Level.SEVERE, stringManager.getString("upgrade.configTransfers.sunacc.startFailureMessage"),ex);
            }  
        }else{
            // Log error message
            logger.log(Level.SEVERE, stringManager.getString("upgrade.configTransfers.sunacc.renameFailureMessage"));
        }
    }
    private String getDOCTYPEString(File target) throws Exception{
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(target)));
        String readLine = null;
        while((readLine = reader.readLine()) != null){
            if(readLine.indexOf("<!DOCTYPE") != -1){
                return readLine;
            }
        }
        return null;
    }

    private String getSecurityConfigValue(File target) throws Exception{
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(target)));
        String readLine = null;
        while((readLine = reader.readLine()) != null){
            if(readLine.indexOf("<property") != -1){
                if(readLine.indexOf("security.config") != -1) { 
                    return readLine;
                }
            }
        }
        return null;
    }

    private void transferFileContents(File source, File target) throws Exception{
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        PrintWriter writer = new PrintWriter(new FileOutputStream(target));
        String readLine = null;
        while((readLine = reader.readLine()) != null){
            if((readLine.indexOf("<!DOCTYPE") == -1) && (readLine.indexOf("<property") == -1)) { 
                writer.println(readLine);
            } else if(readLine.indexOf("<!DOCTYPE") != -1){ 
                if(docType != null)
                    writer.println(docType);
                else
                    writer.println();
            } else if(readLine.indexOf("<property") != -1) {
                if(readLine.indexOf("security.config") != -1) {
                    if(secPolicyProperty != null) 
                        writer.println(secPolicyProperty);
                    else
                        writer.println();
                } else {
                    writer.println(readLine);
                }
            }
        }
        writer.flush();
        writer.close();
        reader.close();
    }
}
