/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Element.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class Property extends BaseElement {
    
    /** Creates a new instance of Element */
    public Property() {
    }
    /**
     * element - Property
     * parentSource - parent of Property
     * parentResult - result element that need to be updated.
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // Property has name and value. and possible description element.
        if(!canTransferAttributes(element, parentSource, parentResult))
            return;
        NodeList resultProperties = parentResult.getElementsByTagName("property");
        Element resultProperty = null;
        if(resultProperties != null){
            for(int index=0; index < resultProperties.getLength(); index++){
                if(element.getAttribute("name").equals(((Element)resultProperties.item(index)).getAttribute("name"))){
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(element.getAttributeNode("value").getValue());
                    this.handleSpecialCases(element, resultProperty, parentSource, parentResult);
                    break;
                }
            }
        }
        if(resultProperty == null){
            resultProperty = parentResult.getOwnerDocument().createElement("property");
            this.transferAttributes(element, resultProperty, null);
            this.handleSpecialCases(element, resultProperty, parentSource, parentResult);
            parentResult.appendChild(resultProperty);
        }        
        super.transform(element, parentSource, resultProperty);
    }  
    
    // This method is used to avoid transferring certain property elements.
    private boolean canTransferAttributes(Element element, Element parentSource, Element parentResult){
        /*if(parentSource.getTagName().equals("virtual-server")){
            if(this.commonInfoModel.getSourceVersion().equals(UpgradeConstants.VERSION_7X)){
                if(element.getAttribute("name").equals("docroot") || element.getAttribute("name").equals("accesslog")){
                    return false;
                }
            }
        }*/
        return true;
    }
    private void handleSpecialCases(Element source, Element target, Element parentSource, Element targetParent){
        if(parentSource.getTagName().equals("jms-resource") && targetParent.getTagName().equals("admin-object-resource")){
            if(source.getAttribute("name").equals("imqDestinationName")){
                target.setAttribute("name", "Name");
            }
        }
        if(parentSource.getTagName().equals("virtual-server")){
            if(source.getAttribute("name").equals("docroot")){
                target.setAttribute("value", "${com.sun.aas.instanceRoot}/docroot");
            }
            if(source.getAttribute("name").equals("accesslog")){
                target.setAttribute("value", "${com.sun.aas.instanceRoot}/logs/access");
            }
        }
    }
    
}
