package com.sun.enterprise.tools.verifier.tests.ejb.ias;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.tools.common.dd.*;
import com.sun.enterprise.tools.common.dd.ejb.*;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;


/** ejb [0,n]
 *    jms-durable-subscription-name ? [String]
 *
 * The jms-durable-subscription-name is the name of a durable subscription associated
 * with a message-driven bean.
 * The name should not be a null string.
 * The value is required if destination-type is Topic
 * and subscription-durability is durable
 * @author Irfan Ahmed
 */
public class ASEjbJMSDurableSubscriptionName extends EjbTest implements EjbCheck { 

    public Result check(EjbDescriptor descriptor) 
    {
	Result result = getInitializedResult();
	ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);

        SunEjbJar ejbJar = descriptor.getEjbBundleDescriptor().getIasEjbObject();
        boolean oneFailed = false;
        
        if(ejbJar!=null)
        {
            Ejb testCase = super.getEjb(descriptor.getName(),ejbJar);
            String jmsDurableName = testCase.getJmsDurableSubscriptionName();
            if(jmsDurableName != null)
            {
                if(jmsDurableName.length()==0)
                {
                    result.failed(smh.getLocalString(getClass().getName()+".failed",
                        "FAILED [AS-EJB ejb] : jms-durable-subscription-name cannot be an empty string value"));
                }
                else
                {
                    result.passed(smh.getLocalString(getClass().getName()+".passed",
                        "PASSED [AS-EJB ejb] : jms-durable-subscription-name is {0}", new Object[]{jmsDurableName}));
                }
            }
            else
            {
                if(descriptor instanceof EjbMessageBeanDescriptor)
                {
                    EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)descriptor;
                    if(msgBeanDesc.hasTopicDest() && msgBeanDesc.hasDurableSubscription())
                    {
                        result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB ejb] : jms-durable-subscription-name should be defined for an MDB with"+
                            " destination type Topic and Durable subscription type"));
                    }
                    else
                    {
                        result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                            "NOT APPLICABLE [AS-EJB ejb] : jms-durable-subscription-name element is not defined"));
                    }
                }
                else
                {
                    result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                        "NOT APPLICABLE [AS-EJB ejb] : jms-durable-subscription-name element is not defined"));
                }
            }
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }
}
