package com.sun.enterprise.tools.verifier.tests.ejb.ias;


/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.security.acl.Role;
import java.lang.reflect.*;

/** ias-ejb-jar
 *    security-role-mapping [0,n]
 *        role-name [String]
 *        principal-name [String] | group-name [String]
 *
 * The element defines the security role mappings for the bean.
 * The role-name should not be an empty string
 * The role-name should be desclared in the assembly-descriptor in the ejb-jar.xml
 * file.
 * The principal-name and group-name should not be empty strings.
 *
 * @author Irfan Ahmed
 */
public class ASSecurityRoleMapping extends EjbTest implements EjbCheck { 

    public Result check(EjbDescriptor descriptor)
    {
        Result result = getInitializedResult();
	ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        SunEjbJar ejbJar = descriptor.getEjbBundleDescriptor().getIasEjbObject();
        
        if(descriptor.getEjbBundleDescriptor().getTestsDone().contains(getClass().getName()))
        {
            result.setStatus(Result.NOT_RUN);
            result.addGoodDetails(smh.getLocalString("iasEjbJar.allReadyRun",
                "NOT RUN [AS-EJB ias-ejb-jar] security-role-mapping is a JAR Level Test. This test has already been run once"));
            return result;
        }
        descriptor.getEjbBundleDescriptor().setTestsDone(getClass().getName());
        
        if(ejbJar!=null)
        {
            SecurityRoleMapping secRoleMapping[] = ejbJar.getSecurityRoleMapping();
            if(secRoleMapping.length>0)
            {
                for(int i=0;i<secRoleMapping.length;i++)
                {
                    String roleName = secRoleMapping[i].getRoleName();
                    if(roleName.length()==0)
                    {
                        oneFailed = true;
                        result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB security-role-mapping] : role-name cannot be an empty string",
                            new Object[]{new Integer(i)}));
                    }
                    else
                    {
                        boolean roleNameFound = false;
                        Set roles = descriptor.getEjbBundleDescriptor().getRoles();
                        Iterator it = roles.iterator();
                        while(it.hasNext())
                        {
                            Role role = (Role)it.next();
                            if(role.getName().equals(roleName))
                            {
                                roleNameFound = true;
                                break;
                            }
                        }
                        if(roleNameFound)
                        {
                            result.passed(smh.getLocalString(getClass().getName()+".passed",
                                "PASSED [AS-EJB security-role-mapping] : role-name {1} verified with ejb-jar.xml",
                                new Object[]{new Integer(i), roleName}));
                        }
                        else
                        {
                            oneFailed = true;
                            //<addition> srini@sun.com Bug: 4721914
                            //result.failed(smh.getLocalString(getClass().getName()+".failed",
                            result.failed(smh.getLocalString(getClass().getName()+".failed1",
                                "FAILED [AS-EJB security-role-mapping] : role-name {1} could not be located in ejb-jar.xml",
                                new Object[]{new Integer(i), roleName}));
                            //<addition>
                        }
                    }

                    String pName[] = secRoleMapping[i].getPrincipalName();
                    for(int j=0;j<pName.length;j++)
                    {
                        if(pName[j].length()==0)
                        {
                            oneFailed = true;
                            //<addition> srini@sun.com Bug: 4721914
                            //result.failed(smh.getLocalString(getClass().getName()+".failed",
                            result.failed(smh.getLocalString(getClass().getName()+".failed2",
                                "FAILED [AS-EJB security-role-mapping] : principal-name cannot be empty string",
                                new Object[]{new Integer(i)}));
                            //<addition>
                        }
                        else
                        {
                            //<addition> srini@sun.com Bug: 4721914
                            //result.passed(smh.getLocalString(getClass().getName()+".passed",
                            result.passed(smh.getLocalString(getClass().getName()+".passed1",
                                "PASSED [AS-EJB security-role-mapping] : principal-name is {1}",
                                new Object[]{new Integer(i),pName[j]}));
                            //<addition>
                        }
                    }

                    pName = secRoleMapping[i].getGroupName();
                    for(int j=0;j<pName.length;j++)
                    {
                        if(pName[j].length()==0)
                        {
                            oneFailed = true;
                            //<addition> srini@sun.com Bug: 4721914
                            //result.failed(smh.getLocalString(getClass().getName()+".failed",
                            result.failed(smh.getLocalString(getClass().getName()+".failed3",
                                "FAILED [AS-EJB security-role-mapping] : group-name cannot be empty string",
                                new Object[]{new Integer(i)}));
                            //<addition>
                        }
                        else
                        {
                            //<addition> srini@sun.com Bug: 4721914
                            //result.passed(smh.getLocalString(getClass().getName()+".passed",
                            result.passed(smh.getLocalString(getClass().getName()+".passed2",
                                "PASSED [AS-EJB security-role-mapping] : group-name is {1}",
                                new Object[]{new Integer(i),pName[j]}));
                            //<addition>
                        }
                    }
                }
            }
            else
            {
                result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                    "NOT APPLICABLE [AS-EJB] : security-role-mapping element is not defined"));
            }
            if(oneFailed)
                result.setStatus(Result.FAILED);
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                                   ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }
}
        
