/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.web.ias;


import com.sun.enterprise.tools.verifier.tests.web.elements.*;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.web.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.common.dd.webapp.*;

//<addition author="irfan@sun.com" [bug/rfe]-id="4711198" >
/* Changed the result messages to reflect consistency between the result messages generated 
 * for the EJB test cases for SunONE specific deployment descriptors*/
//</addition>

public class ASServlet extends WebTest implements WebCheck {



    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        Servlet[] servlets = descriptor.getIasWebApp().getServlet();//######
        //String[] servlets=null;//######
        String servletName;
        String prinName;
	boolean oneFailed = false;
        //System.out.println(" servlet[]" + servlets + " length "+ servlets.length);   
	if (servlets !=null && servlets.length > 0) {
	    for (int rep=0; rep<servlets.length; rep++ ) {
                servletName=servlets[rep].getServletName();//######
                // <addition> srini@sun.com Bug : 4699658
                //prinName=servlets[rep].getPrincipalName();//######
                prinName=servlets[rep].getPrincipalName().trim();//######
                // </addition> Bug : 4699658
                
                      if(validServletName(servletName,descriptor)){

                      result.passed(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "PASSED [AS-WEB servlet] servlet-name [ {0} ] properly defined in the war file.",
					   new Object[] {servletName}));

                      }else{

		        result.failed(smh.getLocalString
					   (getClass().getName() + ".failed",
					    "FAILED [AS-WEB servlet] servlet-name [ {0} ] is not a valid, either empty or not defined in web.xml.",
					    new Object[] {servletName}));
		        oneFailed = true;

                      }

                      if(prinName !=null && ! "".equals(prinName)){

                      result.passed(smh.getLocalString
					  (getClass().getName() + ".passed1",
					   "PASSED [AS-WEB servlet] principal-name [ {0} ] properly defined in the war file.",
					   new Object[] {prinName}));
                      }else{

		        result.failed(smh.getLocalString
					   (getClass().getName() + ".failed1",
					    "FAILED [AS-WEB servlet ] principal-name [ {0} ] cannot be an empty string.",
					    new Object[] {prinName}));
		        oneFailed = true;

                      }

	    }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "NOT APPLICABLE [AS-WEB sun-web-app] servlet element(s) not defined in the web archive [ {0} ].",
				  new Object[] {descriptor.getName()}));
	    return result;
	}

	if (oneFailed)
	    {
		result.setStatus(Result.FAILED);
	    } else {
		result.passed
		    (smh.getLocalString
		     (getClass().getName() + ".passed2",
		      "PASSED [AS-WEB sun-web-app] servlet element(s) are valid within the web archive [ {0} ] .",
                            new Object[] {descriptor.getName()} ));
	    }
	return result;
    }

    boolean validServletName(String servletName, WebBundleDescriptor descriptor){
          boolean valid=false;
          if (servletName != null && servletName.length() != 0) {
              Set servlets = descriptor.getServletDescriptors();
                    Iterator itr = servlets.iterator();
                    // test the servlets in this .war
                    while (itr.hasNext()) {
                        ServletDescriptor servlet = (ServletDescriptor) itr.next();
                        String thisServletName = servlet.getCanonicalName();
			if (servletName.equals(thisServletName)) {
                            valid = true;
                            break;
                        }
                    }

          }
          return valid;
    }
}

