/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class LBDeregistrationUtil {
    private MBeanServer mbs = null;
    private Map<String, NotificationListener> mLBConfigListenersMap = new Hashtable<String, NotificationListener>();
    private static LBDeregistrationUtil mUtil = null;

    private LBDeregistrationUtil(MBeanServer mbs) {
        this.mbs = mbs;
    }

    public static LBDeregistrationUtil getInstance(MBeanServer mbs) {
        if (mUtil == null) {
            mUtil = new LBDeregistrationUtil(mbs);
        }
        return mUtil;
    }

    public LoadBalancerMonitor fetchLBMonitoringRoot(String loadBalancerName) throws JMException {
        ObjectName loadBalancerMonitorObjName = new ObjectName("amx:j2eeType=X-LoadBalancerMonitor,name=" + loadBalancerName);
        LoadBalancerMonitor loadBalancerMonitor = ProxyFactory.getInstance(this.mbs).getProxy(loadBalancerMonitorObjName, LoadBalancerMonitor.class);
        return loadBalancerMonitor;
    }

    public void addLBConfigListener(String loadBalancerName, NotificationListener nl, LBConfig lbConfig) {
        lbConfig.addNotificationListener(nl, null, null);
        this.mLBConfigListenersMap.put(loadBalancerName, nl);
    }

    public void removeLBConfigListener(String loadBalancerName, LBConfig lbConfig) throws JMException {
        lbConfig.removeNotificationListener(this.mLBConfigListenersMap.get(loadBalancerName));
        this.mLBConfigListenersMap.remove(loadBalancerName);
    }
}

