/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCContextualMenuModelInterface;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CCContextualMenuModel
implements CCContextualMenuModelInterface {
    protected String title;
    protected String[] items;
    protected Set disabledSet = new HashSet();
    private String jatoName;
    private Map jatoValues;

    public CCContextualMenuModel(String title) {
        this.setTitle(title);
    }

    public CCContextualMenuModel(String title, String[] items) {
        this.setTitle(title);
        this.setItems(items);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getItems() {
        return this.items != null ? this.items : new String[]{};
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    public boolean isItemEnabled(String item) {
        return !this.disabledSet.contains(item);
    }

    public void setItemEnabled(String item, boolean enabled) {
        if (enabled) {
            this.disabledSet.remove(item);
        } else {
            this.disabledSet.add(item);
        }
    }

    public void addSeparatorItem() {
        this.addItem("CCContextualMenuModelInterface.SEPARATOR", true);
    }

    public void addItem(String item) {
        this.addItem(item, true);
    }

    public synchronized void addItem(String item, boolean enabled) {
        if (this.items == null) {
            this.items = new String[]{item};
        } else {
            String[] newItems = new String[this.items.length + 1];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            newItems[this.items.length] = item;
            this.items = newItems;
        }
        if (!enabled) {
            this.disabledSet.add(item);
        }
    }

    public String getName() {
        return this.jatoName != null ? this.jatoName : this.title;
    }

    public Object getValue(String name) {
        return this.jatoValues != null ? this.jatoValues.get(name) : null;
    }

    public Object[] getValues(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public void setName(String name) {
        this.jatoName = name;
    }

    public synchronized void setValue(String name, Object value) {
        if (this.jatoValues == null) {
            this.jatoValues = new HashMap();
        }
        this.jatoValues.put(name, value);
    }

    public void setValues(String name, Object[] values) {
        this.setValue(name, values);
    }
}

