/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.model.CCRepeatInterval;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class CCDateTimeModel
extends DefaultModel
implements CCDateTimeModelInterface,
Serializable {
    private static final long serialVersionUID = 1267832493720833101L;
    private Date startDateTime;
    private Date endTime;
    private String selectedInterval = null;
    private int repeatLimitUnit = -1;
    private int repeatLimitPeriod = -1;
    private int type = 0;
    private int startYear = -1;
    private int endYear = -1;
    private String startDateLabel = null;
    private String startTimeLabel = null;
    private String endTimeLabel = null;
    private String[] intervalCandidates = new String[]{"onetime", "hourly", "daily", "weekly", "monthly"};
    private Hashtable definedIntervals = new Hashtable();
    private String showRequiredMsg = null;
    private TimeZone timeZone = null;

    public CCDateTimeModel() {
        this.createRepeatInterval("hourly", 0, 1, "datetime.repeatHourly");
        this.createRepeatInterval("daily", 1, 1, "datetime.repeatDaily");
        this.createRepeatInterval("weekly", 2, 1, "datetime.repeatWeekly");
        this.createRepeatInterval("monthly", 3, 1, "datetime.repeatMonthly");
        this.createRepeatInterval("mwf", 4, 21, "datetime.repeatMWF");
        this.createRepeatInterval("tt", 4, 10, "datetime.repeatTT");
        this.createRepeatInterval("ss", 4, 96, "datetime.repeatSS");
        this.createRepeatInterval("mtwtf", 4, 31, "datetime.repeatMTWTF");
        this.createRepeatInterval("onetime", 5, 0, "datetime.repeatOnetime");
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setRepeatIntervals(String[] intervalNames) {
        if (intervalNames != null) {
            this.intervalCandidates = intervalNames;
        }
    }

    public String[] getRepeatIntervals() {
        return this.intervalCandidates;
    }

    public String getSelectedRepeatIntervalName() {
        return this.selectedInterval;
    }

    public void setSelectedRepeatIntervalName(String intervalName) {
        this.selectedInterval = intervalName;
    }

    public int getRepeatLimitUnit() {
        return this.repeatLimitUnit;
    }

    public void setRepeatLimitUnit(int unit) {
        this.repeatLimitUnit = unit;
    }

    public int getRepeatLimitPeriod() {
        return this.repeatLimitPeriod;
    }

    public void setRepeatLimitPeriod(int period) {
        this.repeatLimitPeriod = period;
    }

    public void setType(int dateTimeType) {
        this.type = dateTimeType;
    }

    public int getType() {
        return this.type;
    }

    public int getRepeatIntervalUnit(String repeatIntervalName) {
        int retInt = -1;
        CCRepeatInterval interval = (CCRepeatInterval)this.definedIntervals.get(repeatIntervalName);
        if (interval != null) {
            retInt = interval.getUnit();
        }
        return retInt;
    }

    public int getRepeatIntervalAccount(String repeatIntervalName) {
        int retInt = -1;
        CCRepeatInterval interval = (CCRepeatInterval)this.definedIntervals.get(repeatIntervalName);
        if (interval != null) {
            retInt = interval.getAccount();
        }
        return retInt;
    }

    public String getRepeatIntervalPresentation(String repeatIntervalName) {
        String retStr = null;
        CCRepeatInterval interval = (CCRepeatInterval)this.definedIntervals.get(repeatIntervalName);
        if (interval != null) {
            retStr = interval.getPresentation();
        }
        return retStr;
    }

    public void createRepeatInterval(String name, int unit, int account, String presentation) {
        CCRepeatInterval interval = new CCRepeatInterval(unit, account, presentation);
        this.definedIntervals.put(name, interval);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        DateFormat df1 = DateFormat.getDateInstance(0);
        DateFormat df2 = DateFormat.getTimeInstance(0);
        if (this.timeZone != null) {
            df1.setTimeZone(this.timeZone);
            df2.setTimeZone(this.timeZone);
        }
        buffer.append("Scheduler DATA:\n");
        buffer.append("\tStart Date: " + df1.format(this.startDateTime));
        if (this.type != 2) {
            buffer.append("\n\tStart Time: " + df2.format(this.startDateTime));
            if (this.type == 0 || this.type == 3) {
                String s = null;
                if (this.endTime != null) {
                    s = df2.format(this.endTime);
                }
                buffer.append("\n\tEnd Time: " + s);
            }
            if (this.type == 0) {
                buffer.append("\n\tRepeat Limit, unit: " + this.repeatLimitUnit + ", period: " + this.repeatLimitPeriod);
            }
            if (this.type != 4) {
                buffer.append("\n\t" + this.definedIntervals.get(this.selectedInterval));
            }
        }
        return buffer.toString();
    }

    public boolean isShowRequiredMsgSet() {
        return this.showRequiredMsg != null;
    }

    public boolean getShowRequiredMsg() {
        return this.showRequiredMsg == null ? true : new Boolean(this.showRequiredMsg);
    }

    public void setShowRequiredMsg(boolean showMsg) {
        this.showRequiredMsg = Boolean.toString(showMsg);
    }

    public String getStartDateLabel() {
        return this.startDateLabel;
    }

    public void setStartDateLabel(String label) {
        this.startDateLabel = label;
    }

    public String getStartTimeLabel() {
        return this.startTimeLabel;
    }

    public void setStartTimeLabel(String label) {
        this.startTimeLabel = label;
    }

    public String getEndTimeLabel() {
        return this.endTimeLabel;
    }

    public void setEndTimeLabel(String label) {
        this.endTimeLabel = label;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int start) {
        this.startYear = start;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int end) {
        this.endYear = end;
    }
}

