/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCTopologyIconSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class CCTopologyBadgeSet
implements CCTopologyModelInterface.BadgeSet {
    private final Object context;
    private final Map badges = new HashMap();

    public CCTopologyBadgeSet() {
        this.badges.put(new Integer(0), null);
        this.context = null;
    }

    public CCTopologyBadgeSet(Class context) {
        this.badges.put(new Integer(0), null);
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = context;
    }

    public CCTopologyBadgeSet(ServletContext context) {
        this.badges.put(new Integer(0), null);
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.context = context;
    }

    public final void addBadge(int badge, String location, Color color) {
        if (badge == 0) {
            throw new IllegalArgumentException("badge == NONE (0)");
        }
        this.badges.put(new Integer(badge), new BadgeData(location, color));
    }

    public final void validateImage(int badge) throws IOException, NoClassDefFoundError {
        if (!this.isValid(badge)) {
            throw new IllegalArgumentException("Invalid badge");
        }
        if (badge != 0 && this.getImage(badge) == null) {
            BadgeData bdata = (BadgeData)this.badges.get(new Integer(badge));
            if (bdata.location == null) {
                return;
            }
            if (this.context == null) {
                CCTopologyIconSet.ImageLoader.getImage(bdata.location);
            } else if (this.context instanceof Class) {
                CCTopologyIconSet.ImageLoader.getImage((Class)this.context, bdata.location);
            } else {
                CCTopologyIconSet.ImageLoader.getImage((ServletContext)this.context, bdata.location);
            }
        }
    }

    public final void clearImageCache() {
        if (this.context == null) {
            CCTopologyIconSet.ImageLoader.flushCachedImages();
        } else if (this.context instanceof Class) {
            CCTopologyIconSet.ImageLoader.flushCachedImages((Class)this.context);
        } else {
            CCTopologyIconSet.ImageLoader.flushCachedImages((ServletContext)this.context);
        }
    }

    public void finalize() {
        this.clearImageCache();
    }

    public final int[] getValidIds() {
        Integer[] keys = this.badges.keySet().toArray(new Integer[0]);
        int[] ids = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = keys[i];
        }
        return ids;
    }

    public final boolean isValid(int badge) {
        return this.badges.containsKey(new Integer(badge));
    }

    public Image getImage(int badge) {
        BadgeData bdata = (BadgeData)this.badges.get(new Integer(badge));
        return bdata == null || bdata.location == null ? null : (this.context == null ? CCTopologyIconSet.ImageLoader.getCachedImage(bdata.location) : (this.context instanceof Class ? CCTopologyIconSet.ImageLoader.getCachedImage((Class)this.context, bdata.location) : CCTopologyIconSet.ImageLoader.getCachedImage((ServletContext)this.context, bdata.location)));
    }

    public final Color getColor(int badge) {
        BadgeData bdata = (BadgeData)this.badges.get(new Integer(badge));
        return bdata == null ? (Color)null : bdata.color;
    }

    public int getCombinedBadge(int badge1, int badge2) {
        return Math.max(badge1, badge2);
    }

    private static final class BadgeData {
        public final String location;
        public final Color color;

        public BadgeData(String location, Color color) {
            this.location = location;
            this.color = color;
        }
    }
}

