/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.command;

import com.iplanet.jato.command.Command;
import com.iplanet.jato.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;

public class CommandDescriptor {
    private String commandClassName;
    private Command command;
    private Class commandClass;
    private String operationName = "DEFAULT";
    private Map parameters = new HashMap();

    public CommandDescriptor() {
    }

    public CommandDescriptor(String commandClassName, String operationName) {
        this.commandClassName = commandClassName;
        this.operationName = operationName;
    }

    public CommandDescriptor(Class commandClass, String operationName) {
        this.commandClass = commandClass;
        this.operationName = operationName;
    }

    public CommandDescriptor(Command command, String operationName) {
        this.command = command;
        this.operationName = operationName;
    }

    public CommandDescriptor(String commandClassName, String operationName, Map parameters) {
        this(commandClassName, operationName);
        this.parameters = parameters;
    }

    public CommandDescriptor(Class commandClass, String operationName, Map parameters) {
        this(commandClass, operationName);
        this.parameters = parameters;
    }

    public CommandDescriptor(Command command, String operationName, Map parameters) {
        this(command, operationName);
        this.parameters = parameters;
    }

    public String getCommandClassName() {
        return this.commandClassName;
    }

    public void setCommandClassName(String value) {
        this.commandClassName = value;
        this.commandClass = null;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command value) {
        this.command = value;
        if (value != null) {
            this.setCommandClass(value.getClass());
            this.setCommandClassName(value.getClass().getName());
        } else {
            this.setCommandClass(null);
            this.setCommandClassName(null);
        }
    }

    public Class getCommandClass() {
        if (this.commandClass == null) {
            try {
                if (this.getCommandClassName() != null) {
                    this.commandClass = ClassUtil.getClass(this.getCommandClassName());
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Could not find a class for command class name property \"" + this.getCommandClassName() + "\"");
            }
        }
        if (this.commandClass == null) {
            this.commandClass = this.getDefaultCommandClass();
        }
        return this.commandClass;
    }

    public void setCommandClass(Class value) {
        this.commandClass = value;
        this.commandClassName = value != null ? value.getName() : null;
    }

    protected Class getDefaultCommandClass() {
        return null;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String value) {
        this.operationName = value;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map value) {
        this.parameters = value;
    }

    public Object getParameter(Object key) {
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return null;
    }

    public void setParameter(Object key, Object value) {
        if (this.parameters != null) {
            this.parameters.put(key, value);
        }
    }
}

