/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.component.ConfigPropertyDescriptor;
import com.iplanet.jato.component.design.ComponentDesignContext;
import com.iplanet.jato.model.ModelFieldChooser;
import com.iplanet.jato.model.ModelFieldGroupDescriptor;
import com.iplanet.jato.model.ModelFieldInfo;
import com.iplanet.jato.model.SimpleModelFieldChooser;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleModelFieldGroupDescriptor
extends ModelFieldGroupDescriptor {
    public ResourceBundleModelFieldGroupDescriptor() {
    }

    public ResourceBundleModelFieldGroupDescriptor(String groupName, Class groupType, ConfigPropertyDescriptor[] configPropertyDescriptors, Class fieldType, String addFieldToGroupMethod, String addGroupToModelMethod) {
        super(groupName, groupType, configPropertyDescriptors, fieldType, addFieldToGroupMethod, addGroupToModelMethod);
    }

    public ModelFieldChooser getModelFieldChooser(ComponentDesignContext context) {
        ResourceBundle bundle;
        String bundleName = (String)context.getConfigPropertyContext().getPropertyValue("BundleName");
        if (null == bundleName || bundleName.trim().length() == 0) {
            return null;
        }
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), context.getApplicationClassLoader());
        }
        catch (MissingResourceException mre) {
            context.getLogWriter().println(mre.toString());
            return null;
        }
        if (null == bundle || !bundle.getKeys().hasMoreElements()) {
            return null;
        }
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<ModelFieldInfo> info = new ArrayList<ModelFieldInfo>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            info.add(new ModelFieldInfo(key, null));
        }
        SimpleModelFieldChooser chooser = new SimpleModelFieldChooser(info.toArray(new ModelFieldInfo[info.size()]));
        chooser.setName(this.getGroupName());
        chooser.setDisplayName(this.getGroupDisplayName());
        return chooser;
    }
}

