/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.util.StringTokenizer2;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class Log {
    public static final int NONE = 0;
    public static final int MANDATORY = 512;
    public static final int STD = 1;
    public static final int STANDARD = 1;
    public static final int VERBOSE_DEBUG = 2;
    public static final int TERSE_DEBUG = 4;
    public static final int ANY_DEBUG = 6;
    public static final int JATO_TRACE = 8;
    public static final int JATO_QOS_TRACE = 256;
    public static final int APP_TRACE = 16;
    public static final int ANY_TRACE = 280;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int CRITICAL = 128;
    public static final int ANY_ERROR = 224;
    public static final int USER_LEVEL_1 = 8192;
    public static final int USER_LEVEL_2 = 16384;
    public static final int USER_LEVEL_3 = 32768;
    public static final int ANY_USER_LEVEL = 57344;
    public static final int ALL_LOG_LEVELS = 58367;
    public static final int DEFAULT_LOG_LEVELS = 737;
    private static boolean ECHO_TO_SYSTEM_OUT;
    public static int ENABLED_LOG_LEVELS;
    private static String MESSAGE_PREFIX;
    private static ServletContext servletContext;
    private static final Map LOG_LEVEL_STRINGS;
    private static final Map LOG_LEVEL_INTS;
    private static final Map LOG_LEVEL_PREFIXES;
    private static final int[] LOG_LEVEL_ARRAY;

    private Log() {
    }

    protected static ServletContext getServletContext() {
        return servletContext;
    }

    protected static void setServletContext(ServletContext context) {
        servletContext = context;
    }

    public static boolean getEchoToSystemOut() {
        return ECHO_TO_SYSTEM_OUT;
    }

    public static void setEchoToSystemOut(boolean value) {
        ECHO_TO_SYSTEM_OUT = value;
    }

    public static String getMessagePrefix() {
        return MESSAGE_PREFIX;
    }

    public static void setMessagePrefix(String value) {
        if (value == null) {
            value = "";
        }
        MESSAGE_PREFIX = value;
    }

    public static void log(Object message) {
        if (message != null) {
            Log.log(message.toString());
        } else {
            Log.log("null");
        }
    }

    public static void log(String message) {
        ServletContext context = Log.getServletContext();
        if (context != null) {
            context.log(MESSAGE_PREFIX + message);
            if (ECHO_TO_SYSTEM_OUT) {
                System.out.println(MESSAGE_PREFIX + message);
            }
        } else {
            System.out.println(MESSAGE_PREFIX + message);
        }
    }

    public static void log(int level, Object message) {
        if (message != null) {
            Log.log(level, message.toString());
        } else {
            Log.log(level, "null");
        }
    }

    public static void log(int level, String message) {
        if (Log.isLevelEnabled(level)) {
            Log.log(Log.getLevelNamePrefix(level) + message);
        }
    }

    public static void log(int level, String message, Throwable exception) {
        if (Log.isLevelEnabled(level)) {
            Log.log(Log.getLevelNamePrefix(level) + message, exception);
        }
    }

    public static void log(String message, Throwable exception) {
        ServletContext context = Log.getServletContext();
        if (context != null) {
            context.log(MESSAGE_PREFIX + message, exception);
            if (ECHO_TO_SYSTEM_OUT) {
                System.out.println(MESSAGE_PREFIX + message);
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
        } else {
            System.out.println(MESSAGE_PREFIX + message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public static int getEnabledLevels() {
        return ENABLED_LOG_LEVELS;
    }

    public static void setEnabledLevels(int level) {
        ENABLED_LOG_LEVELS = level | 0x200;
    }

    public static boolean isLevelEnabled(int level) {
        return level == 512 || (level & ENABLED_LOG_LEVELS) > 0;
    }

    public static String getLevelName(int level) {
        String result = (String)LOG_LEVEL_INTS.get(new Integer(level));
        if (result == null) {
            result = "UNKNOWN_LEVEL(" + level + ")";
        }
        return result;
    }

    private static String getLevelNamePrefix(int level) {
        String result = (String)LOG_LEVEL_PREFIXES.get(new Integer(level));
        if (result == null) {
            result = "[UNKNOWN_LEVEL(" + level + ")] ";
        }
        return result;
    }

    public static int parseLogLevelString(String levelString) {
        if (levelString == null || levelString.trim().length() == 0) {
            return 0;
        }
        int result = 0;
        String[] tokens = StringTokenizer2.tokenize(levelString, "|", true);
        int i = 0;
        while (i < tokens.length) {
            try {
                Integer level = (Integer)LOG_LEVEL_STRINGS.get(tokens[i]);
                if (level != null) {
                    result |= level.intValue();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public static String getLogLevelsString(int levels) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < LOG_LEVEL_ARRAY.length) {
            if ((levels & LOG_LEVEL_ARRAY[i]) > 0) {
                if (result.length() > 0) {
                    result.append(" | ");
                }
                result.append(Log.getLevelName(LOG_LEVEL_ARRAY[i]));
            }
            ++i;
        }
        return result.toString();
    }

    public static String getEnabledLevelsString() {
        return Log.getLogLevelsString(Log.getEnabledLevels());
    }

    static {
        NONE = 0;
        MANDATORY = 512;
        STD = 1;
        STANDARD = 1;
        VERBOSE_DEBUG = 2;
        TERSE_DEBUG = 4;
        ANY_DEBUG = 6;
        JATO_TRACE = 8;
        JATO_QOS_TRACE = 256;
        APP_TRACE = 16;
        ANY_TRACE = 280;
        WARNING = 32;
        ERROR = 64;
        CRITICAL = 128;
        ANY_ERROR = 224;
        USER_LEVEL_1 = 8192;
        USER_LEVEL_2 = 16384;
        USER_LEVEL_3 = 32768;
        ANY_USER_LEVEL = 57344;
        ALL_LOG_LEVELS = 58367;
        DEFAULT_LOG_LEVELS = 737;
        ECHO_TO_SYSTEM_OUT = false;
        ENABLED_LOG_LEVELS = 737;
        MESSAGE_PREFIX = "";
        LOG_LEVEL_STRINGS = new HashMap();
        LOG_LEVEL_INTS = new HashMap();
        LOG_LEVEL_PREFIXES = new HashMap();
        LOG_LEVEL_STRINGS.put("NONE", new Integer(0));
        LOG_LEVEL_STRINGS.put("MANDATORY", new Integer(512));
        LOG_LEVEL_STRINGS.put("STD", new Integer(1));
        LOG_LEVEL_STRINGS.put("STANDARD", new Integer(1));
        LOG_LEVEL_STRINGS.put("VERBOSE_DEBUG", new Integer(2));
        LOG_LEVEL_STRINGS.put("TERSE_DEBUG", new Integer(4));
        LOG_LEVEL_STRINGS.put("ANY_DEBUG", new Integer(6));
        LOG_LEVEL_STRINGS.put("JATO_TRACE", new Integer(8));
        LOG_LEVEL_STRINGS.put("JATO_QOS_TRACE", new Integer(256));
        LOG_LEVEL_STRINGS.put("APP_TRACE", new Integer(16));
        LOG_LEVEL_STRINGS.put("ANY_TRACE", new Integer(280));
        LOG_LEVEL_STRINGS.put("WARNING", new Integer(32));
        LOG_LEVEL_STRINGS.put("ERROR", new Integer(64));
        LOG_LEVEL_STRINGS.put("CRITICAL", new Integer(128));
        LOG_LEVEL_STRINGS.put("ANY_ERROR", new Integer(224));
        LOG_LEVEL_STRINGS.put("USER_LEVEL_1", new Integer(8192));
        LOG_LEVEL_STRINGS.put("USER_LEVEL_2", new Integer(16384));
        LOG_LEVEL_STRINGS.put("USER_LEVEL_3", new Integer(32768));
        LOG_LEVEL_STRINGS.put("ANY_USER_LEVEL", new Integer(57344));
        LOG_LEVEL_STRINGS.put("ALL_LOG_LEVELS", new Integer(58367));
        LOG_LEVEL_STRINGS.put("ALL", new Integer(58367));
        LOG_LEVEL_STRINGS.put("DEFAULT_LOG_LEVELS", new Integer(737));
        LOG_LEVEL_STRINGS.put("DEFAULT", new Integer(737));
        LOG_LEVEL_INTS.put(new Integer(512), "MANDATORY");
        LOG_LEVEL_INTS.put(new Integer(1), "STANDARD");
        LOG_LEVEL_INTS.put(new Integer(2), "VERBOSE_DEBUG");
        LOG_LEVEL_INTS.put(new Integer(4), "TERSE_DEBUG");
        LOG_LEVEL_INTS.put(new Integer(8), "JATO_TRACE");
        LOG_LEVEL_INTS.put(new Integer(256), "JATO_QOS_TRACE");
        LOG_LEVEL_INTS.put(new Integer(16), "APP_TRACE");
        LOG_LEVEL_INTS.put(new Integer(32), "WARNING");
        LOG_LEVEL_INTS.put(new Integer(64), "ERROR");
        LOG_LEVEL_INTS.put(new Integer(128), "CRITICAL");
        LOG_LEVEL_INTS.put(new Integer(8192), "USER_LEVEL_1");
        LOG_LEVEL_INTS.put(new Integer(16384), "USER_LEVEL_2");
        LOG_LEVEL_INTS.put(new Integer(32768), "USER_LEVEL_3");
        LOG_LEVEL_ARRAY = new int[]{512, 1, 2, 4, 8, 256, 16, 32, 64, 128, 8192, 16384, 32768};
        int i = 0;
        while (i < LOG_LEVEL_ARRAY.length) {
            LOG_LEVEL_PREFIXES.put(new Integer(LOG_LEVEL_ARRAY[i]), "[" + LOG_LEVEL_INTS.get(new Integer(LOG_LEVEL_ARRAY[i])) + "] ");
            ++i;
        }
    }
}

