/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.component.OrderableListBase;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.util.ValueType;
import com.sun.web.ui.util.ValueTypeEvaluator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

public class OrderableList
extends OrderableListBase
implements ListManager,
NamingContainer {
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEUP_TEXT_KEY = "OrderableList.moveUp";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String MOVEDOWN_TEXT_KEY = "OrderableList.moveDown";
    public static final String MOVETOP_BUTTON_ID = "_moveTopButton";
    public static final String MOVETOP_BUTTON_FACET = "moveTopButton";
    public static final String MOVETOP_TEXT_KEY = "OrderableList.moveTop";
    public static final String MOVEBOTTOM_BUTTON_ID = "_moveBottomButton";
    public static final String MOVEBOTTOM_BUTTON_FACET = "moveBottomButton";
    public static final String MOVEBOTTOM_TEXT_KEY = "OrderableList.moveBottom";
    public static final String LABEL_ID = "_label";
    public static final String LABEL_FACET = "label";
    public static final String LABEL_TEXT_KEY = "OrderableList.defaultListLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String FOOTER_FACET = "footer";
    public static final String JSOBJECT = "com.sun.web.ui.OrderableListJS";
    public static final String JAVASCRIPT_PREFIX = "javascript: ";
    public static final String RETURN = "return false;";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String MOVETOP_FUNCTION = ".moveTop(); ";
    public static final String MOVEBOTTOM_FUNCTION = ".moveBottom();";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String ONCHANGE_FUNCTION = ".onChange(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    private ValueTypeEvaluator valueTypeEvaluator = new ValueTypeEvaluator((UIComponent)this);
    private ArrayList listItems = null;
    private transient Theme theme = null;
    private static final boolean DEBUG = false;

    public UIComponent getMoveUpButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEUP_BUTTON_FACET, true, this.getTheme().getMessage(MOVEUP_TEXT_KEY), MOVEUP_FUNCTION);
    }

    public UIComponent getMoveDownButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEDOWN_BUTTON_FACET, true, this.getTheme().getMessage(MOVEDOWN_TEXT_KEY), MOVEDOWN_FUNCTION);
    }

    public UIComponent getMoveTopButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVETOP_BUTTON_FACET, false, this.getTheme().getMessage(MOVETOP_TEXT_KEY), MOVETOP_FUNCTION);
    }

    public UIComponent getMoveBottomButtonComponent(FacesContext context) {
        return this.getButtonFacet(MOVEBOTTOM_BUTTON_FACET, false, this.getTheme().getMessage(MOVEBOTTOM_TEXT_KEY), MOVEBOTTOM_FUNCTION);
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, String onclickFunction) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
        }
        this.initButtonFacet(button, primary, text, onclickFunction);
        ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text, String onclickFunction) {
        String jsobj;
        button.setPrimary(primary);
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        if ((jsobj = (String)this.getAttributes().get(JSOBJECT)) != null) {
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(jsobj);
            jsBuffer.append(onclickFunction);
            jsBuffer.append(RETURN);
            button.setOnClick(jsBuffer.toString());
        }
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getHeaderComponent() {
        String labelString = this.getLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(LABEL_FACET, labelString, (UIComponent)this);
    }

    private UIComponent getLabelFacet(String facetName, String text, UIComponent forComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
        }
        this.initLabelFacet(label, text, forComponent);
        ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        return label;
    }

    private void initLabelFacet(Label label, String labelString, UIComponent forComponent) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        label.setText(labelString);
        label.setLabelLevel(this.getLabelLevel());
        label.setLabeledComponent(forComponent);
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public Iterator getListItems(FacesContext context, boolean ruler) throws FacesException {
        this.listItems = new ArrayList();
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue != null && submittedValue instanceof String[]) {
            ListItem listItem = null;
            String[] values = (String[])submittedValue;
            for (int counter = 0; counter < values.length; ++counter) {
                listItem = new ListItem(values[counter], values[counter]);
                listItem.setValue(values[counter]);
                this.listItems.add(listItem);
            }
            return this.listItems.iterator();
        }
        Object listItemsObject = this.getList();
        if (listItemsObject != null) {
            if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                Iterator items = ((List)listItemsObject).iterator();
                while (items.hasNext()) {
                    Object item = items.next();
                    this.listItems.add(this.createListItem((UIComponent)this, item));
                }
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                Object[] listObjects = (Object[])listItemsObject;
                for (int counter = 0; counter < listObjects.length; ++counter) {
                    this.listItems.add(this.createListItem((UIComponent)this, listObjects[counter]));
                }
            } else {
                String msg = this.getTheme().getMessage("OrderableList.invalidListType");
                throw new FacesException(msg);
            }
        }
        return this.listItems.iterator();
    }

    protected ListItem createListItem(UIComponent comp, Object value) {
        if (value == null) {
            throw new NullPointerException("OrderableList ListItems cannot have null values");
        }
        String label = ConversionUtilities.convertValueToString(comp, value);
        ListItem listItem = new ListItem(value, label);
        listItem.setValue(label);
        return listItem;
    }

    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        Object cValue = null;
        try {
            if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                cValue = ConversionUtilities.convertValueToArray((UIComponent)this, rawValues, context);
            } else if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
                cValue = ConversionUtilities.convertValueToList((UIComponent)this, rawValues, context);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return cValue;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuffer valueBuffer = new StringBuffer(200);
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.indexOf("nbsp") > -1) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READ_ONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public int getRows() {
        int rows = super.getRows();
        if (rows < 1) {
            rows = 12;
            super.setRows(12);
        }
        return rows;
    }

    public String getOnChange() {
        return null;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public boolean mainListSubmits() {
        return false;
    }
}

