/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.model.Markup;
import com.sun.web.ui.util.RenderingUtilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public abstract class AbstractRenderer
extends Renderer {
    protected static final String BUNDLE = "com.sun.web.ui.renderer.Bundle";
    public static final String[] EVENTS_ATTRIBUTES = new String[]{"onClick", "onDblClick", "onChange", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp"};
    public static final String[] I18N_ATTRIBUTES = new String[]{"dir", "lang"};
    private static final String[] coreAttributes = new String[]{"style", "title"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component instanceof EditableValueHolder) {
            this.setSubmittedValue(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderStart(context, component, writer);
            this.renderAttributes(context, component, writer);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                RenderingUtilities.renderComponent(kid, context);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnd(context, component, writer);
        }
    }

    protected void addBooleanAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            boolean flag;
            Object value = attributes.get(names[i]);
            if (value == null || !(flag = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue())) continue;
            writer.writeAttribute(names[i].toLowerCase(), (Object)names[i].toLowerCase(), names[i]);
            flag = false;
        }
    }

    protected void addCoreAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String styles) throws IOException {
        String id = component.getId();
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        RenderingUtilities.renderStyleClass(context, writer, component, styles);
        AbstractRenderer.addStringAttributes(context, component, writer, coreAttributes);
    }

    protected void addIntegerAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            Integer ivalue;
            Object value = attributes.get(names[i]);
            if (value == null || !(value instanceof Integer) || (ivalue = (Integer)value) == Integer.MIN_VALUE) continue;
            writer.writeAttribute(names[i].toLowerCase(), (Object)ivalue, names[i]);
        }
    }

    protected static void addStringAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            Object value = attributes.get(names[i]);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(names[i].toLowerCase(), (Object)((String)value), names[i]);
                continue;
            }
            writer.writeAttribute(names[i].toLowerCase(), (Object)value.toString(), names[i]);
        }
    }

    protected Application getApplication() {
        return this.getFacesContext().getApplication();
    }

    protected Object getAsObject(FacesContext context, UIComponent component, String value) {
        Class clazz;
        ValueBinding vb;
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && (vb = component.getValueBinding("value")) != null && (clazz = vb.getType(context)) != null) {
            converter = this.getApplication().createConverter(clazz);
        }
        if (converter != null) {
            return converter.getAsObject(context, component, value);
        }
        return value;
    }

    protected String getAsString(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        Object value = ((ValueHolder)component).getValue();
        if (value == null) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (value instanceof String) {
                return (String)value;
            }
            converter = this.getApplication().createConverter(value.getClass());
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        return value.toString();
    }

    protected ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map parameters = context.getExternalContext().getRequestParameterMap();
        return parameters.get(clientId);
    }

    protected boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.valueOf((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    protected boolean isPortlet(FacesContext context) {
        return false;
    }

    protected boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.valueOf((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderMarkup(FacesContext context, UIComponent component, ResponseWriter writer, Markup markup) throws IOException {
        writer.write(markup.getMarkup());
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void setSubmittedValue(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        component.getAttributes().put("submittedValue", this.getSubmittedValue(context, component));
    }
}

