/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.TimeStamp;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TimeStampRenderer
extends AbstractRenderer {
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        TimeStamp timeStamp = (TimeStamp)component;
        Theme theme = ThemeUtilities.getTheme(context);
        if (!timeStamp.isRendered()) {
            return;
        }
        String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
        writer.startElement("span", (UIComponent)timeStamp);
        this.addCoreAttributes(context, (UIComponent)timeStamp, writer, textStyle);
        String message = timeStamp.getText();
        if (message == null) {
            message = theme.getMessage("masthead.lastUpdate");
        }
        writer.write(message);
        writer.endElement("span");
        writer.write("&nbsp;");
        writer.startElement("span", (UIComponent)timeStamp);
        this.addCoreAttributes(context, (UIComponent)timeStamp, writer, textStyle);
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1, locale);
        writer.write(dateFormat.format(new Date()));
        writer.endElement("span");
    }
}

