/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.server.PersistenceUnitInfoImpl;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceProcessor
extends BaseProcessor {
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW = "oracle.toplink.essentials.PersistenceProvider";
    private PersistenceUnitInfo pi;

    public PersistenceProcessor(DeploymentEventInfo info, boolean deploy, boolean redeploy, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        super(info, deploy, redeploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    @Override
    protected void processApplication() {
        Collection<PersistenceUnitsDescriptor> bundleCollection = this.getAllPersistenceUnitDescriptors(this.application);
        if (bundleCollection.size() == 0) {
            return;
        }
        this.setApplicationLocation();
        this.setGeneratedLocation();
        for (PersistenceUnitsDescriptor pus : bundleCollection) {
            for (PersistenceUnitDescriptor bundle : pus.getPersistenceUnitDescriptors()) {
                this.processAppBundle(bundle);
            }
        }
    }

    private Collection<PersistenceUnitsDescriptor> getAllPersistenceUnitDescriptors(Application application) {
        EjbBundleDescriptor bundle;
        ArrayList<PersistenceUnitsDescriptor> allPUs = new ArrayList<PersistenceUnitsDescriptor>(application.getPersistenceUnitsDescriptors());
        for (Object o : application.getEjbBundleDescriptors()) {
            bundle = (EjbBundleDescriptor)EjbBundleDescriptor.class.cast(o);
            allPUs.addAll(bundle.getPersistenceUnitsDescriptors());
        }
        for (Object o : application.getWebBundleDescriptors()) {
            bundle = (WebBundleDescriptor)WebBundleDescriptor.class.cast(o);
            allPUs.addAll(bundle.getPersistenceUnitsDescriptors());
        }
        return allPUs;
    }

    private void processAppBundle(PersistenceUnitDescriptor bundle) {
        String ddlGenerate = this.getPersistencePropVal(bundle, "toplink.ddl-generation", "none");
        boolean createTables = this.getCreateTablesValue(bundle, ddlGenerate);
        boolean dropTables = this.getDropTablesValue(bundle, ddlGenerate);
        if (this.debug) {
            logger.fine("ejb.PersistenceProcessor.createanddroptables", new Object[]{new Boolean(createTables), new Boolean(dropTables)});
        }
        if (!createTables && !dropTables) {
            return;
        }
        this.constructJdbcFileNames(bundle);
        if (this.debug) {
            logger.fine("ejb.PersistenceProcessor.createanddropfilenames", this.createJdbcFileName, this.dropJdbcFileName);
        }
        this.dropTablesFromDB(dropTables, bundle);
        this.createTablesInDB(createTables, bundle);
    }

    protected boolean getCreateTablesValue(PersistenceUnitDescriptor bundle, String ddlGenerate) {
        boolean createTables = this.deploy && (this.cliCreateTables.equals("true") || ddlGenerate.equals("create-tables") || ddlGenerate.equals("drop-and-create-tables") && this.cliCreateTables.equals("undefined"));
        return createTables;
    }

    protected boolean getDropTablesValue(PersistenceUnitDescriptor bundle, String ddlGenerate) {
        boolean dropTables = this.redeploy && (this.cliDropAndCreateTables.equals("true") || ddlGenerate.equals("drop-and-create-tables") && this.cliDropAndCreateTables.equals("undefined")) || !this.deploy && (this.cliDropTables.equals("true") || ddlGenerate.equals("drop-and-create-tables") && this.cliDropTables.equals("undefined"));
        return dropTables;
    }

    private void constructJdbcFileNames(PersistenceUnitDescriptor parBundle) {
        this.createJdbcFileName = this.getPersistencePropVal(parBundle, "toplink.create-ddl-jdbc-file-name", null);
        this.dropJdbcFileName = this.getPersistencePropVal(parBundle, "toplink.drop-ddl-jdbc-file-name", null);
        if (null != this.createJdbcFileName && null != this.dropJdbcFileName) {
            return;
        }
        String filePrefix = EJBHelper.getDDLNamePrefix(parBundle.getParent().getParent());
        if (null == this.createJdbcFileName) {
            this.createJdbcFileName = filePrefix + '_' + parBundle.getName() + "_createDDL.jdbc";
        }
        if (null == this.dropJdbcFileName) {
            this.dropJdbcFileName = filePrefix + '_' + parBundle.getName() + "_dropDDL.jdbc";
        }
    }

    protected boolean dropTablesFromDB(boolean dropTables, PersistenceUnitDescriptor bundle) {
        boolean dropResult = false;
        File dropFile = null;
        if (dropTables && (dropFile = this.getDropDDLFile(this.dropJdbcFileName, this.deploy)).exists()) {
            PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(bundle, this.appDeployedLocation, null);
            dropResult = this.executeDDLStatement(dropFile, pi.getNonJtaDataSource());
        }
        return dropResult;
    }

    protected boolean createTablesInDB(boolean createTables, PersistenceUnitDescriptor bundle) {
        boolean createResult = false;
        if (createTables) {
            this.pi = this.loadPersistenceUnitBundle(bundle, this.createJdbcFileName, this.dropJdbcFileName);
            if (null == this.pi) {
                return createResult;
            }
            File createFile = this.getCreateDDLFile(this.appGeneratedLocation + this.createJdbcFileName);
            if (createFile.exists()) {
                createResult = this.executeDDLStatement(createFile, this.pi.getNonJtaDataSource());
            }
            createResult = true;
        }
        return createResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDLStatement(File fileName, DataSource nonJtaDataSource) {
        boolean result = false;
        Connection conn = null;
        Statement sql = null;
        try {
            try {
                conn = nonJtaDataSource.getConnection();
                sql = conn.createStatement();
                result = true;
            }
            catch (SQLException ex) {
                this.logI18NWarnMessage("ejb.BaseProcessor.cannotConnect", this.appRegisteredName, null, ex);
            }
            if (result) {
                this.executeDDLs(fileName, sql);
            }
        }
        catch (IOException e) {
            this.fileIOError(this.application.getRegistrationName(), e);
        }
        finally {
            PersistenceProcessor.closeConn(conn);
        }
        return result;
    }

    private void addPropertiesToPU(PersistenceUnitDescriptor puDescriptor) {
        this.addPropertyToDescriptor(puDescriptor, "toplink.application-location", this.appGeneratedLocation);
        this.addPropertyToDescriptor(puDescriptor, "toplink.ddl-generation", "drop-and-create-tables");
        this.addPropertyToDescriptor(puDescriptor, "toplink.ddl-generation.output-mode", "sql-script");
        this.addPropertyToDescriptor(puDescriptor, "toplink.create-ddl-jdbc-file-name", this.createJdbcFileName);
        this.addPropertyToDescriptor(puDescriptor, "toplink.drop-ddl-jdbc-file-name", this.dropJdbcFileName);
    }

    private void addPropertyToDescriptor(PersistenceUnitDescriptor descriptor, String propertyName, String propertyValue) {
        String oldPropertyValue = descriptor.getProperties().getProperty(propertyName);
        if (null == oldPropertyValue) {
            descriptor.addProperty(propertyName, (Object)propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceUnitInfo loadPersistenceUnitBundle(PersistenceUnitDescriptor persistenceUnitDescriptor, String createJdbcFileName, String dropJdbcFileName) {
        logger.entering("loadPersistenceUnitBundle", "load", new Object[]{persistenceUnitDescriptor});
        if (!this.isSupportedPersistenceProvider(persistenceUnitDescriptor)) {
            return null;
        }
        this.addPropertiesToPU(persistenceUnitDescriptor);
        InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(persistenceUnitDescriptor.getClassLoader());
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(persistenceUnitDescriptor, this.appDeployedLocation, cl);
        if (this.debug) {
            logger.fine("PersistenceInfo for PU is :\n" + pi);
        }
        EntityManagerFactoryProvider provider = new EntityManagerFactoryProvider();
        EntityManagerFactory emf = null;
        try {
            emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, null);
            emf.createEntityManager();
            if (this.debug) {
                logger.fine("PersistenceProcessor", "loadPersistenceUnitBundle", "emf = {0}", emf);
            }
        }
        finally {
            if (emf != null) {
                emf.close();
            }
        }
        return pi;
    }

    private String getPersistencePropVal(PersistenceUnitDescriptor parBundle, String propertyName, String defaultValue) {
        String propertyValue = null == defaultValue ? parBundle.getProperties().getProperty(propertyName) : parBundle.getProperties().getProperty(propertyName, defaultValue);
        return propertyValue;
    }

    private boolean isSupportedPersistenceProvider(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        boolean result;
        String providerClassName = PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc((PersistenceUnitDescriptor)persistenceUnitDescriptor);
        boolean bl = result = providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD) || providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW);
        if (!result) {
            this.logI18NInfoMessage("ejb.PersistenceProcessor.nondefaultprovider", TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD, providerClassName, null);
        }
        return result;
    }
}

