/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.layout.xml;

import com.sun.enterprise.tools.jsfext.layout.LayoutDefinitionManager;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.xml.XMLLayoutDefinitionReader;
import com.sun.enterprise.tools.jsfext.util.ClasspathEntityResolver;
import com.sun.enterprise.tools.jsfext.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLayoutDefinitionManager
extends LayoutDefinitionManager {
    private static Map layouts = new HashMap();
    private static LayoutDefinitionManager instance = null;
    private static final Class[] GET_REAL_PATH_ARGS = new Class[]{String.class};
    public static final String ENTITY_RESOLVER = "entityResolver";
    public static final String ERROR_HANDLER = "errorHandler";
    public static final String BASE_URI = "baseURI";
    private static boolean DEBUG = Boolean.getBoolean("com.sun.enterprise.tools.jsfext.DEBUG");

    protected XMLLayoutDefinitionManager() {
        try {
            this.setErrorHandler(new XMLErrorHandler(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF-8"), true)));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.setEntityResolver(new ClasspathEntityResolver());
    }

    public static LayoutDefinitionManager getInstance() {
        if (instance == null) {
            instance = new XMLLayoutDefinitionManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutDefinition getLayoutDefinition(String key) throws IOException {
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        LayoutDefinition ld = (LayoutDefinition)layouts.get(key);
        if (DEBUG) {
            ld = null;
        }
        if (ld == null) {
            ClassLoader loader;
            String url;
            String baseURI = this.getBaseURI();
            URL ldURL = null;
            Object ctx = FacesContext.getCurrentInstance().getExternalContext().getContext();
            Method method = null;
            try {
                method = ctx.getClass().getMethod("getRealPath", GET_REAL_PATH_ARGS);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            try {
                if (baseURI == null) {
                    baseURI = "file:///" + method.invoke(ctx, "/");
                }
                url = (String)method.invoke(ctx, key);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            if (url != null && new File(url).canRead()) {
                try {
                    ldURL = new URL("file:///" + url);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create URL: 'file:///" + url + "' while attempting to locate '" + key + "'", ex);
                }
            }
            if (ldURL == null && (ldURL = (loader = Util.getClassLoader(key)).getResource(key)) == null && (ldURL = loader.getResource("/" + key)) == null) {
                ldURL = loader.getResource("META-INF/" + key);
            }
            if (ldURL == null) {
                throw new FileNotFoundException("Unable to locate '" + key + "'");
            }
            try {
                ld = new XMLLayoutDefinitionReader(ldURL, this.getEntityResolver(), this.getErrorHandler(), baseURI).read();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to process '" + ldURL + "'.  EntityResolver: '" + this.getEntityResolver() + "'.  ErrorHandler: '" + this.getErrorHandler() + "'.  baseURI: '" + baseURI + "'.", ex);
            }
            Map map = layouts;
            synchronized (map) {
                layouts.put(key, ld);
            }
        }
        return ld;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.getAttribute(ENTITY_RESOLVER);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setAttribute(ENTITY_RESOLVER, entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.getAttribute(ERROR_HANDLER);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.setAttribute(ERROR_HANDLER, errorHandler);
    }

    public String getBaseURI() {
        return (String)this.getAttribute(BASE_URI);
    }

    public void setBaseURI(String baseURI) {
        this.setAttribute(BASE_URI, baseURI);
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        XMLErrorHandler(PrintWriter outWriter) {
            this.out = outWriter;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

