/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.libraries.asm.attrs;

import oracle.toplink.libraries.asm.Attribute;
import oracle.toplink.libraries.asm.ByteVector;
import oracle.toplink.libraries.asm.ClassReader;
import oracle.toplink.libraries.asm.ClassWriter;
import oracle.toplink.libraries.asm.Label;

public class EnclosingMethodAttribute
extends Attribute {
    public String owner;
    public String name;
    public String desc;

    public EnclosingMethodAttribute() {
        super("EnclosingMethod");
    }

    public EnclosingMethodAttribute(String owner, String name, String desc) {
        this();
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        String o = cr.readClass(off, buf);
        int index = cr.getItem(cr.readUnsignedShort(off + 2));
        String n = null;
        String d = null;
        if (index != 0) {
            n = cr.readUTF8(index, buf);
            d = cr.readUTF8(index + 2, buf);
        }
        return new EnclosingMethodAttribute(o, n, d);
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        return new ByteVector().putShort(cw.newClass(this.owner)).putShort(this.name == null || this.desc == null ? 0 : cw.newNameType(this.name, this.desc));
    }

    public String toString() {
        return new StringBuffer("owner:").append(this.owner).append(" name:").append(this.name).append(" desc:").append(this.desc).toString();
    }
}

