/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.ICommand;
import com.sun.enterprise.cli.framework.ValidOption;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValidCommand
implements ICommand,
Serializable {
    private String name;
    private String numberOfOperands;
    private Vector validOptions;
    private Vector requiredOptions;
    private Vector deprecatedOptions;
    private String className;
    private String usageText = null;
    private Hashtable properties;
    private String defaultOperand = null;
    private static final transient String DEFAULTOPERAND_QUANTIFIER_REGEXP = "[\\*\\?]";

    public ValidCommand() {
        this.validOptions = new Vector();
        this.requiredOptions = new Vector();
        this.deprecatedOptions = new Vector();
        this.properties = new Hashtable();
    }

    public ValidCommand(String name, String numberOfOperands, Vector validOptions, Vector requiredOptions, Vector deprecatedOptions, String usageText) {
        this.name = name;
        this.numberOfOperands = numberOfOperands;
        this.validOptions = validOptions;
        this.requiredOptions = requiredOptions;
        this.deprecatedOptions = deprecatedOptions;
        this.usageText = usageText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumberOfOperands() {
        return this.numberOfOperands;
    }

    public String getDefaultOperand() {
        return this.defaultOperand;
    }

    public void setNumberOfOperands(String numberOfOperands) {
        this.numberOfOperands = numberOfOperands;
    }

    public void setDefaultOperand(String defaultOperand) {
        this.defaultOperand = defaultOperand != null && this.numberOfOperands.matches(DEFAULTOPERAND_QUANTIFIER_REGEXP) ? defaultOperand : null;
    }

    public Vector getValidOptions() {
        return this.validOptions;
    }

    public void setValidOptions(Vector validOptions) {
        this.validOptions = validOptions;
    }

    public Vector getRequiredOptions() {
        return this.requiredOptions;
    }

    public void setRequiredOptions(Vector requiredOptions) {
        this.requiredOptions = requiredOptions;
    }

    public Vector getDeprecatedOptions() {
        return this.deprecatedOptions;
    }

    public void setDeprecatedOptions(Vector deprecatedOptions) {
        this.deprecatedOptions = deprecatedOptions;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public void setUsageText(String usageText) {
        this.usageText = usageText;
    }

    public ValidOption getOption(String longOptionName) {
        Vector allOptions = this.getOptions();
        if (longOptionName != null) {
            for (int ii = 0; ii < allOptions.size(); ++ii) {
                ValidOption option = (ValidOption)allOptions.get(ii);
                if (!option.getName().equals(longOptionName)) continue;
                return option;
            }
        }
        return null;
    }

    public ValidOption getAlternateDeprecatedOption(String optionName) {
        Vector allOptions = new Vector(this.validOptions);
        allOptions.addAll(this.requiredOptions);
        boolean hasAltDeprecatedOption = false;
        ValidOption altDeprecatedOption = null;
        for (int i = 0; i < allOptions.size() && !hasAltDeprecatedOption; ++i) {
            ValidOption validOption = (ValidOption)allOptions.get(i);
            String deprecatedOptionStr = validOption.getDeprecatedOption();
            if (deprecatedOptionStr == null || !deprecatedOptionStr.equals(optionName)) continue;
            hasAltDeprecatedOption = true;
            altDeprecatedOption = validOption;
        }
        return altDeprecatedOption;
    }

    public Vector getOptions() {
        Vector options = new Vector(this.validOptions);
        options.addAll(this.requiredOptions);
        options.addAll(this.deprecatedOptions);
        return options;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void addValidOption(ValidOption option) {
        if (option != null && !this.hasValidOption(option.getName())) {
            this.validOptions.add(option);
        }
    }

    public void addRequiredOption(ValidOption option) {
        if (option != null && !this.hasRequiredOption(option.getName())) {
            this.requiredOptions.add(option);
        }
    }

    public void addDeprecatedOption(ValidOption option) {
        if (option != null && !this.hasDeprecatedOption(option.getName())) {
            this.deprecatedOptions.add(option);
        }
    }

    public void deleteOption(ValidOption option) {
        if (option != null) {
            this.validOptions.remove(option);
        }
    }

    public boolean hasValidOption(String optionName) {
        boolean hasValidOption = false;
        if (optionName != null) {
            for (int i = 0; i < this.validOptions.size() && !hasValidOption; ++i) {
                if (!((ValidOption)this.validOptions.get(i)).getName().equals(optionName)) continue;
                hasValidOption = true;
            }
        }
        return hasValidOption;
    }

    public boolean hasValidOption(ValidOption option) {
        return this.validOptions.contains(option);
    }

    public boolean hasRequiredOption(String optionName) {
        boolean hasRequiredOption = false;
        for (int i = 0; i < this.requiredOptions.size() && !hasRequiredOption; ++i) {
            if (!((ValidOption)this.requiredOptions.get(i)).getName().equals(optionName)) continue;
            hasRequiredOption = true;
        }
        return hasRequiredOption;
    }

    public boolean hasRequiredOption(ValidOption option) {
        return this.requiredOptions.contains(option);
    }

    public boolean hasDeprecatedOption(String optionName) {
        boolean hasDeprecatedOption = false;
        for (int i = 0; i < this.deprecatedOptions.size() && !hasDeprecatedOption; ++i) {
            if (!((ValidOption)this.deprecatedOptions.get(i)).getName().equals(optionName)) continue;
            hasDeprecatedOption = true;
        }
        return hasDeprecatedOption;
    }

    public boolean hasDeprecatedOption(ValidOption option) {
        return this.deprecatedOptions.contains(option);
    }

    public boolean hasAlternateDeprecatedOption(String optionName) {
        Vector allOptions = new Vector(this.validOptions);
        allOptions.addAll(this.requiredOptions);
        boolean hasAltDeprecatedOption = false;
        for (int i = 0; i < allOptions.size() && !hasAltDeprecatedOption; ++i) {
            String deprecatedOptionStr = ((ValidOption)allOptions.get(i)).getDeprecatedOption();
            if (deprecatedOptionStr == null || !deprecatedOptionStr.equals(optionName)) continue;
            hasAltDeprecatedOption = true;
        }
        return hasAltDeprecatedOption;
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public void replaceAllOptions(ValidOption replaceOption) {
        if (replaceOption != null) {
            String replaceOptionName = replaceOption.getName();
            if (this.hasValidOption(replaceOptionName)) {
                this.replaceOptionsList(this.validOptions, replaceOption);
            }
            if (this.hasRequiredOption(replaceOptionName)) {
                this.replaceOptionsList(this.requiredOptions, replaceOption);
            }
            if (this.hasDeprecatedOption(replaceOptionName)) {
                this.replaceOptionsList(this.deprecatedOptions, replaceOption);
            }
        }
    }

    private void replaceOptionsList(Vector optionsList, ValidOption replaceOption) {
        String replaceOptionName = replaceOption.getName();
        for (int ii = 0; ii < optionsList.size(); ++ii) {
            try {
                if (!((ValidOption)optionsList.get(ii)).getName().equals(replaceOptionName)) continue;
                if (((ValidOption)optionsList.get(ii)).hasDeprecatedOption()) {
                    String deprecatedOption = ((ValidOption)optionsList.get(ii)).getDeprecatedOption();
                    replaceOption.setDeprecatedOption(deprecatedOption);
                }
                optionsList.set(ii, replaceOption);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        String validOptionsStr = "{";
        for (int i = 0; i < this.validOptions.size(); ++i) {
            validOptionsStr = validOptionsStr + this.validOptions.get(i).toString() + ",";
        }
        validOptionsStr = validOptionsStr + "}";
        String requiredOptionsStr = "";
        for (int i = 0; i < this.requiredOptions.size(); ++i) {
            requiredOptionsStr = requiredOptionsStr + this.requiredOptions.get(i).toString() + ",";
        }
        requiredOptionsStr = requiredOptionsStr + "}";
        String deprecatedOptionsStr = "";
        for (int i = 0; i < this.deprecatedOptions.size(); ++i) {
            deprecatedOptionsStr = deprecatedOptionsStr + this.deprecatedOptions.get(i).toString() + ",";
        }
        deprecatedOptionsStr = deprecatedOptionsStr + "}";
        String propertiesStr = "{";
        Enumeration propertyNames = this.properties.keys();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Vector value = (Vector)this.properties.get(name);
            propertiesStr = propertiesStr + "|" + name + " , " + value;
        }
        propertiesStr = propertiesStr + "}";
        return this.name + " " + this.numberOfOperands + " | " + validOptionsStr + " | " + requiredOptionsStr + " | " + " | " + deprecatedOptionsStr + " | " + this.usageText + " " + propertiesStr;
    }
}

