/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.logging;

import com.sun.corba.ee.spi.orb.ORB;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogWrapperBase {
    private Logger logger = null;
    protected String loggerName;

    protected LogWrapperBase(String loggerName) {
        this.loggerName = loggerName;
    }

    protected synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = ORB.getLogger(this.loggerName);
        }
        return this.logger;
    }

    protected void doLog(Level level, String key, Object[] params, Class wrapperClass, Throwable thr) {
        LogRecord lrec = new LogRecord(level, key);
        if (params != null) {
            lrec.setParameters(params);
        }
        if (level != Level.INFO) {
            this.inferCaller(wrapperClass, lrec);
            lrec.setThrown(thr);
        }
        lrec.setLoggerName(this.loggerName);
        Logger lgr = this.getLogger();
        lrec.setResourceBundle(lgr.getResourceBundle());
        lgr.log(lrec);
    }

    private void inferCaller(Class wrapperClass, LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = wrapperClass.getName();
        String baseName = LogWrapperBase.class.getName();
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).equals(wcname) || cname.equals(baseName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    protected void doLog(Level level, String key, Class wrapperClass, Throwable thr) {
        this.doLog(level, key, null, wrapperClass, thr);
    }
}

