/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.Invocation;
import com.sun.ejb.containers.EJBContextImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class AroundInvokeInterceptor {
    protected int index;
    protected Method method;

    AroundInvokeInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
    }

    Object intercept(final Invocation invCtx) throws Throwable {
        try {
            final Object[] interceptors = ((EJBContextImpl)invCtx.context).getInterceptorInstances();
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!AroundInvokeInterceptor.this.method.isAccessible()) {
                        AroundInvokeInterceptor.this.method.setAccessible(true);
                    }
                    return AroundInvokeInterceptor.this.method.invoke(interceptors[AroundInvokeInterceptor.this.index], invCtx);
                }
            });
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    public String toString() {
        return "[" + this.index + "]: " + this.method;
    }
}

