/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChangeFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.List;

class DependencyResolver {
    private ConfigContext _ctx;
    private String _target;

    DependencyResolver(ConfigContext ctx, String target) {
        this._ctx = ctx;
        this._target = target;
    }

    List resolveResources(String resName, String action, String typeInEvent) throws ConfigException {
        ArrayList list = new ArrayList();
        if (resName == null || "reference-removed".equals(action) || "undeploy".equals(action)) {
            return list;
        }
        ConfigBean res = this.findResource(resName, typeInEvent);
        if (res == null) {
            return list;
        }
        if ("jdbc".equals(typeInEvent)) {
            String poolName = ((JdbcResource)res).getPoolName();
            list.addAll(this.resolveJdbcConnectionPool(poolName));
        } else if ("cr".equals(typeInEvent)) {
            String poolName = ((ConnectorResource)res).getPoolName();
            list.addAll(this.resolveConnectorConnectionPool(poolName));
        } else if ("pmf".equals(typeInEvent)) {
            String jdbcResName = ((PersistenceManagerFactoryResource)res).getJdbcResourceJndiName();
            list.addAll(this.resolveResources(jdbcResName, action, "jdbc"));
        }
        list.addAll(this.addConfigChangeForResource(res));
        return list;
    }

    List resolveApplications(String applicationName, String action) throws ConfigException {
        ArrayList<ConfigAdd> list = new ArrayList<ConfigAdd>();
        if (applicationName == null || "reference-removed".equals(action) || "redeploy".equals(action) || "undeploy".equals(action)) {
            return list;
        }
        ConfigBean app = ApplicationHelper.findApplication(this._ctx, applicationName);
        if (app == null) {
            return list;
        }
        String xpath = app.getXPath();
        ConfigAdd configAdd = ConfigChangeFactory.createConfigAdd(this._ctx, xpath);
        list.add(configAdd);
        ResourceAdapterConfig raConfig = this.findResourceAdapterConfigByName(applicationName);
        if (raConfig != null) {
            ConfigAdd raConfigChange = ConfigChangeFactory.createConfigAdd(this._ctx, raConfig.getXPath());
            list.add(raConfigChange);
        }
        return list;
    }

    private List addConfigChangeForResource(ConfigBean res) throws ConfigException {
        ArrayList<ConfigAdd> list = new ArrayList<ConfigAdd>();
        if (res == null) {
            return list;
        }
        String xpath = res.getXPath();
        ConfigAdd configAdd = ConfigChangeFactory.createConfigAdd(this._ctx, xpath);
        list.add(configAdd);
        return list;
    }

    List getConfigDeleteForApplication(String applicationName) throws ConfigException {
        ArrayList<ConfigDelete> list = new ArrayList<ConfigDelete>();
        if (applicationName != null) {
            ConfigBean app = ApplicationHelper.findApplication(this._ctx, applicationName);
            String xpath = app.getXPath();
            ConfigDelete configDelete = ConfigChangeFactory.createConfigDelete(xpath);
            list.add(configDelete);
        }
        return list;
    }

    List getConfigDeleteForResource(String resName, String resTypeInEvent) throws ConfigException {
        ConfigBean res = this.findResource(resName, resTypeInEvent);
        return this.getConfigDeleteForResource(res);
    }

    List getConfigDeleteForResource(ConfigBean res) throws ConfigException {
        ArrayList<ConfigDelete> list = new ArrayList<ConfigDelete>();
        if (res == null) {
            return list;
        }
        String xpath = res.getXPath();
        ConfigDelete configDelete = ConfigChangeFactory.createConfigDelete(xpath);
        list.add(configDelete);
        return list;
    }

    private List resolveJdbcConnectionPool(String poolName) throws ConfigException {
        ArrayList list = new ArrayList();
        if (poolName == null) {
            return list;
        }
        Resources root = ((Domain)this._ctx.getRootConfigBean()).getResources();
        JdbcConnectionPool pool = root.getJdbcConnectionPoolByName(poolName);
        if (pool == null) {
            return list;
        }
        list.addAll(this.addConfigChangeForResource(pool));
        return list;
    }

    private List resolveConnectorConnectionPool(String poolName) throws ConfigException {
        ArrayList list = new ArrayList();
        if (poolName == null) {
            return list;
        }
        Resources root = ((Domain)this._ctx.getRootConfigBean()).getResources();
        ConnectorConnectionPool pool = root.getConnectorConnectionPoolByName(poolName);
        if (pool == null) {
            return list;
        }
        list.addAll(this.addConfigChangeForResource(pool));
        return list;
    }

    ResourceAdapterConfig findResourceAdapterConfigByName(String name) throws ConfigException {
        Resources root = ((Domain)this._ctx.getRootConfigBean()).getResources();
        ResourceAdapterConfig[] configs = root.getResourceAdapterConfig();
        if (configs != null) {
            for (int i = 0; i < configs.length; ++i) {
                String fullRAName = configs[i].getResourceAdapterName();
                String raName = this.getApplicationNameFromRAName(fullRAName);
                if (!raName.equals(name)) continue;
                return configs[i];
            }
        }
        return null;
    }

    String getApplicationNameFromRAName(String fullRAName) {
        String appName = null;
        int idx = fullRAName.indexOf("#");
        appName = idx > 0 ? fullRAName.substring(0, idx) : fullRAName;
        return appName;
    }

    ConfigBean findResource(String resName, String type) throws ConfigException {
        ConfigBean res = null;
        Resources root = ((Domain)this._ctx.getRootConfigBean()).getResources();
        if ("jdbc".equals(type)) {
            res = root.getJdbcResourceByJndiName(resName);
        } else if ("mail".equals(type)) {
            res = root.getMailResourceByJndiName(resName);
        } else if ("custom".equals(type)) {
            res = root.getCustomResourceByJndiName(resName);
        } else if ("external-jndi".equals(type)) {
            res = root.getExternalJndiResourceByJndiName(resName);
        } else if ("pmf".equals(type)) {
            res = root.getPersistenceManagerFactoryResourceByJndiName(resName);
        } else if ("aor".equals(type)) {
            res = root.getAdminObjectResourceByJndiName(resName);
        } else if ("cr".equals(type)) {
            res = root.getConnectorResourceByJndiName(resName);
        } else if ("jcp".equals(type)) {
            res = root.getJdbcConnectionPoolByName(resName);
        } else if ("ccp".equals(type)) {
            res = root.getConnectorConnectionPoolByName(resName);
        } else if ("rac".equals(type)) {
            res = root.getResourceAdapterConfigByResourceAdapterName(resName);
        }
        return res;
    }
}

