/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.admin.meta.MBeanMetaConstants;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.org.apache.commons.modeler.AttributeInfo;
import com.sun.org.apache.commons.modeler.FeatureInfo;
import com.sun.org.apache.commons.modeler.FieldInfo;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.OperationInfo;
import com.sun.org.apache.commons.modeler.ParameterInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.management.AttributeList;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class MBeanMetaHelper
implements MBeanMetaConstants {
    static int ONLY_CHILD = 1;
    static int MULTY_CHILDS = 2;
    static int SETTER_METHODTYPE = 1;
    static int GETTER_METHODTYPE = 2;
    static Class[] _clsStr = new Class[]{new String().getClass()};
    static Class[] _clsStrArr = new Class[]{new String[0].getClass()};
    static Class[] _clsAttr = new Class[]{MBeanMetaHelper.forNameOrNull("javax.management.Attribute")};
    static Class[] _clsAttrList = new Class[]{MBeanMetaHelper.forNameOrNull("javax.management.AttributeList")};
    static Class[] _clsServAndOname = new Class[]{MBeanMetaHelper.forNameOrNull("javax.management.MBeanServer"), MBeanMetaHelper.forNameOrNull("javax.management.ObjectName")};
    static Class[] _clsModelMBI = new Class[]{MBeanMetaHelper.forNameOrNull("javax.management.modelmbean.ModelMBeanInfo")};
    static Class[] _clsBoolean = new Class[]{new Boolean(true).getClass()};
    static Class[] _clsObjAndStr = new Class[]{new Object().getClass(), new String().getClass()};
    static Class[] _clsInvokeParms = new Class[]{new String().getClass(), new Object[0].getClass(), new String[0].getClass()};
    private static String[] strArray = new String[0];

    public static void mergeWithConfigBean(ManagedBean managedBean, Class objectClass, int mode) {
        if (objectClass == null) {
            return;
        }
        Hashtable<String, AttrIntro> attrs = new Hashtable<String, AttrIntro>();
        Hashtable<String, String> children = new Hashtable<String, String>();
        int shift = 0;
        Method[] methods = objectClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Class<?>[] params;
            String methodName = methods[j].getName();
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                int n = shift = methodName.startsWith("is") ? 2 : 3;
                if (Modifier.isStatic(methods[j].getModifiers()) || !Modifier.isPublic(methods[j].getModifiers()) || (params = methods[j].getParameterTypes()).length != 0 || methods[j].getDeclaringClass() != objectClass) continue;
                Class<?> ret = methods[j].getReturnType();
                if (!MBeanMetaHelper.supportedType(ret)) {
                    String childClassName = ret.getName();
                    if (!childClassName.endsWith("." + methodName.substring(shift)) && !childClassName.endsWith("." + methodName.substring(shift) + ";")) continue;
                    children.put(methodName.substring(shift), childClassName);
                    continue;
                }
                if ((mode & 1) == 0) continue;
                AttrIntro ai = (AttrIntro)attrs.get(MBeanMetaHelper.getAttrNameFromMethodName(methodName, true));
                if (ai == null) {
                    ai = new AttrIntro();
                    ai.name = MBeanMetaHelper.getAttrNameFromMethodName(methodName, true);
                    attrs.put(ai.name, ai);
                }
                if (ai.type != null) {
                    if (!ai.type.equals(ret.getName())) {
                        continue;
                    }
                } else {
                    ai.type = ret.getName();
                }
                ai.getName = methodName;
                continue;
            }
            if (!methodName.startsWith("set") || (mode & 2) == 0 || (params = methods[j].getParameterTypes()).length != 1 || !MBeanMetaHelper.supportedType(params[0]) || !Modifier.isPublic(methods[j].getModifiers()) || methods[j].getDeclaringClass() != objectClass) continue;
            AttrIntro ai = (AttrIntro)attrs.get(MBeanMetaHelper.getAttrNameFromMethodName(methodName, true));
            if (ai == null) {
                ai = new AttrIntro();
                ai.name = MBeanMetaHelper.getAttrNameFromMethodName(methodName, true);
                attrs.put(ai.name, ai);
            }
            if (ai.type != null) {
                if (!ai.type.equals(params[0].getName())) {
                    continue;
                }
            } else {
                ai.type = params[0].getName();
            }
            ai.setName = methodName;
            if (!methodName.startsWith("setDefault")) continue;
            ai.setName = "set" + methodName.substring(3);
        }
        if (attrs.size() > 0) {
            AttributeInfo[] infos = managedBean.getAttributes();
            Hashtable<String, AttributeInfo> infosTable = new Hashtable<String, AttributeInfo>();
            for (int i = 0; i < infos.length; ++i) {
                infosTable.put(infos[i].getName(), infos[i]);
            }
            Enumeration keys = attrs.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                AttrIntro ai = (AttrIntro)attrs.get(key);
                AttributeInfo info = (AttributeInfo)infosTable.get(key);
                if (info == null) {
                    ai.whereType = "CBEAN";
                    info = ai.createAttributeInfo();
                    managedBean.addAttribute(info);
                    infosTable.put(key, info);
                    continue;
                }
                ai.mergeWithAttributeInfo(info);
            }
            OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("getDefaultAttributeValue", "INFO", "java.lang.String", new ParameterInfo("attributeName", "java.lang.String", null), "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
        }
        String nameClass = "javax.management.ObjectName";
        String attrClass = "javax.management.Attribute";
        String namesClass = new ObjectName[0].getClass().getName();
        String attrListClass = new AttributeList().getClass().getName();
        String stringsClass = new String[0].getClass().getName();
        if (children.get("ElementProperty") != null) {
            children.remove("ElementProperty");
            OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("getProperties", "INFO", attrListClass, null, "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
            operationInfo = MBeanMetaHelper.createOperationInfo("getPropertyValue", "INFO", "java.lang.Object", new ParameterInfo("propertyName", "java.lang.String", null), "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
            operationInfo = MBeanMetaHelper.createOperationInfo("setProperty", "ACTION", "void", new ParameterInfo("nameAndValue", attrClass, null), "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
        }
        if (children.get("SystemProperty") != null) {
            children.remove("SystemProperty");
            OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("getSystemProperties", "INFO", attrListClass, null, "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
            operationInfo = MBeanMetaHelper.createOperationInfo("getSystemPropertyValue", "INFO", "java.lang.Object", new ParameterInfo("propertyName", "java.lang.String", null), "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
            operationInfo = MBeanMetaHelper.createOperationInfo("setSystemProperty", "ACTION", "void", new ParameterInfo("nameAndValue", attrClass, null), "CBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
        }
        if (children.size() > 0) {
            Enumeration keys = children.keys();
            block3: while (keys.hasMoreElements()) {
                String methodName;
                int j;
                String prefix;
                String key = (String)keys.nextElement();
                String clazz = (String)children.get(key);
                boolean bMulti = clazz.charAt(0) == '[';
                String childName = MBeanMetaHelper.getAttrNameFromMethodName(key, true, '-');
                if ((mode & 8) != 0) {
                    OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("get" + key, "INFO", bMulti ? namesClass : nameClass, null, "CBEAN");
                    MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                    MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                    if (bMulti) {
                        operationInfo = MBeanMetaHelper.createOperationInfo("get" + key + "NamesList", "INFO", stringsClass, null, null);
                        MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                        MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                    }
                    if (bMulti) {
                        prefix = "get" + key + "By";
                        for (j = 0; j < methods.length; ++j) {
                            methodName = methods[j].getName();
                            if (!methodName.startsWith(prefix)) continue;
                            operationInfo = MBeanMetaHelper.createOperationInfo(methodName, "INFO", nameClass, new ParameterInfo("key", "java.lang.String", null), "CBEAN");
                            MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                            break;
                        }
                    }
                }
                if ((mode & 4) != 0) {
                    prefix = bMulti ? "add" + key : "set" + key;
                    for (j = 0; j < methods.length; ++j) {
                        methodName = methods[j].getName();
                        if (!methodName.startsWith(prefix)) continue;
                        OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("create" + key, "ACTION_INFO", nameClass, new ParameterInfo("attribute_list", attrListClass, null), "CBEAN");
                        MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                        MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                        break;
                    }
                }
                if ((mode & 0x10) == 0) continue;
                if (!bMulti) {
                    OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("remove" + key, "ACTION", "void", null, "CBEAN");
                    MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                    MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                    continue;
                }
                prefix = "get" + key + "By";
                for (j = 0; j < methods.length; ++j) {
                    methodName = methods[j].getName();
                    if (!methodName.startsWith(prefix)) continue;
                    OperationInfo operationInfo = MBeanMetaHelper.createOperationInfo("remove" + methodName.substring(3), "ACTION", "void", new ParameterInfo("key", "java.lang.String", null), "CBEAN");
                    MBeanMetaHelper.addDataToChildOperInfo(childName, bMulti, operationInfo);
                    MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
                    continue block3;
                }
            }
        }
    }

    public static AttrIntro findOrCreateAttrInfo(Hashtable attrs, String attrName, String methodName, Class supposedTypeClass, String whereType, int methodType) {
        AttrIntro ai = (AttrIntro)attrs.get(attrName);
        if (ai == null) {
            ai = new AttrIntro();
            ai.name = attrName;
            ai.type = supposedTypeClass.getName();
            if ((methodType & GETTER_METHODTYPE) != 0) {
                ai.getName = methodName;
            }
            if ((methodType & SETTER_METHODTYPE) != 0) {
                ai.setName = methodName;
            }
            ai.getName = methodName;
            ai.whereType = whereType;
            attrs.put(ai.name, ai);
        } else if (ai.type == null || ai.type.equals(supposedTypeClass.getName())) {
            if ((methodType & GETTER_METHODTYPE) != 0) {
                ai.getName = methodName;
            }
            if ((methodType & SETTER_METHODTYPE) != 0) {
                ai.setName = methodName;
            }
        } else {
            return null;
        }
        return ai;
    }

    public static void mergeWithRuntimeModelBean(ManagedBean managedBean, Class objectClass) {
        if (objectClass == null) {
            return;
        }
        Hashtable attrs = new Hashtable();
        Method[] methods = objectClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            if (Modifier.isStatic(methods[j].getModifiers()) || !Modifier.isPublic(methods[j].getModifiers()) || methods[j].getDeclaringClass() == Object.class) continue;
            String methodName = methods[j].getName();
            Class<?>[] params = methods[j].getParameterTypes();
            Class<?> ret = methods[j].getReturnType();
            if ((methodName.startsWith("get") || methodName.startsWith("is")) && params.length == 0 && MBeanMetaHelper.supportedType(ret)) {
                MBeanMetaHelper.findOrCreateAttrInfo(attrs, MBeanMetaHelper.getAttrNameFromMethodName(methodName, false), methodName, ret, "RBEAN", GETTER_METHODTYPE);
                continue;
            }
            if (methodName.startsWith("set") && params.length == 1 && MBeanMetaHelper.supportedType(params[0])) {
                MBeanMetaHelper.findOrCreateAttrInfo(attrs, MBeanMetaHelper.getAttrNameFromMethodName(methodName, false), methodName, params[0], "RBEAN", SETTER_METHODTYPE);
                continue;
            }
            OperationInfo operationInfo = MBeanMetaHelper.getOperationInfo(methods[j], "RBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
        }
        if (attrs.size() > 0) {
            AttributeInfo[] infos = managedBean.getAttributes();
            Hashtable<String, AttributeInfo> infosTable = new Hashtable<String, AttributeInfo>();
            for (int i = 0; i < infos.length; ++i) {
                infosTable.put(infos[i].getName(), infos[i]);
            }
            Enumeration keys = attrs.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                AttrIntro ai = (AttrIntro)attrs.get(key);
                AttributeInfo info = (AttributeInfo)infosTable.get(key);
                if (info == null) {
                    ai.whereType = "RBEAN";
                    info = ai.createAttributeInfo();
                    managedBean.addAttribute(info);
                    infosTable.put(key, info);
                    continue;
                }
                ai.mergeWithAttributeInfo(info);
            }
        }
    }

    private static Class forNameOrNull(String str) {
        try {
            return Class.forName(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isMethodMatch(Method m, String name, Class[] clParams) {
        if (!name.equals(m.getName())) {
            return false;
        }
        Class<?>[] cls = m.getParameterTypes();
        if (clParams == null) {
            return cls == null || cls.length == 0;
        }
        if (cls == null) {
            return clParams.length == 0;
        }
        if (clParams.length != cls.length) {
            return false;
        }
        for (int i = 0; i < cls.length; ++i) {
            if (clParams[i].equals(cls[i])) continue;
            return false;
        }
        return true;
    }

    public static void mergeWithDynamicMBean(ManagedBean managedBean, Class objectClass) {
        if (objectClass == null) {
            return;
        }
        Method[] methods = objectClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Class<?> declaringClass;
            if (Modifier.isStatic(methods[j].getModifiers()) || !Modifier.isPublic(methods[j].getModifiers()) || methods[j].getDeclaringClass() == Object.class || NotificationBroadcasterSupport.class.equals(declaringClass = methods[j].getDeclaringClass())) continue;
            String methodName = methods[j].getName();
            if (MBeanMetaHelper.isMethodMatch(methods[j], "getAttribute", _clsStr) || MBeanMetaHelper.isMethodMatch(methods[j], "getAttributes", _clsStrArr) || MBeanMetaHelper.isMethodMatch(methods[j], "setAttribute", _clsAttr) || MBeanMetaHelper.isMethodMatch(methods[j], "setAttributes", _clsAttrList) || MBeanMetaHelper.isMethodMatch(methods[j], "preRegister", _clsServAndOname) || MBeanMetaHelper.isMethodMatch(methods[j], "postRegister", _clsBoolean) || MBeanMetaHelper.isMethodMatch(methods[j], "preDeregister", null) || MBeanMetaHelper.isMethodMatch(methods[j], "postDeregister", null) || MBeanMetaHelper.isMethodMatch(methods[j], "setManagedResource", _clsObjAndStr) || MBeanMetaHelper.isMethodMatch(methods[j], "setModelMBeanInfo", _clsModelMBI) || MBeanMetaHelper.isMethodMatch(methods[j], "getMBeanInfo", null) || MBeanMetaHelper.isMethodMatch(methods[j], "invoke", _clsInvokeParms)) continue;
            OperationInfo operationInfo = MBeanMetaHelper.getOperationInfo(methods[j], "MBEAN");
            MBeanMetaHelper.mergeWithOperationInfo(managedBean, operationInfo);
        }
    }

    private static OperationInfo getOperationInfo(Method method, String whereType) {
        OperationInfo info = new OperationInfo();
        info.setName(method.getName());
        info.setReturnType(method.getReturnType().getName());
        Class<?>[] paramsClasses = method.getParameterTypes();
        for (int k = 0; k < paramsClasses.length; ++k) {
            info.addParameter(new ParameterInfo("param" + (k + 1), paramsClasses[k].getName(), null));
        }
        if (whereType != null) {
            info.addField(MBeanMetaHelper.newField("bean", whereType));
        }
        return info;
    }

    private static OperationInfo createOperationInfo(String name, String impact, String returnType, ParameterInfo param, String whereType) {
        OperationInfo info = new OperationInfo();
        info.setName(name);
        info.setImpact(impact);
        if (returnType != null) {
            info.setReturnType(returnType);
        }
        if (param != null) {
            info.addParameter(param);
        }
        if (whereType != null) {
            info.addField(MBeanMetaHelper.newField("bean", whereType));
        }
        return info;
    }

    private static void mergeWithOperationInfo(ManagedBean managedBean, OperationInfo info) {
        managedBean.addOperation(info);
    }

    private static boolean supportedType(Class ret) {
        return ret == String.class || ret == Integer.class || ret == Integer.TYPE || ret == Long.class || ret == Long.TYPE || ret == File.class || ret == Boolean.class || ret == Boolean.TYPE || ret == strArray.getClass() || ret == ObjectName.class;
    }

    private static String getAttrNameFromMethodName(String name, boolean bDecamelaze) {
        return MBeanMetaHelper.getAttrNameFromMethodName(name, bDecamelaze, '-');
    }

    private static String getAttrNameFromMethodName(String name, boolean bDecamelaze, char separatorSymbol) {
        if (name.startsWith("set") || name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        }
        if (!bDecamelaze) {
            return name;
        }
        if (name.length() == 0) {
            return name;
        }
        String attrName = name.toLowerCase();
        char[] arr1 = name.toCharArray();
        char[] arr2 = name.toLowerCase().toCharArray();
        StringBuffer buf = new StringBuffer(arr1.length * 2);
        buf.append(arr2[0]);
        for (int i = 1; i < arr1.length; ++i) {
            if (arr1[i] != arr2[i]) {
                buf.append(separatorSymbol);
            }
            buf.append(arr2[i]);
        }
        return buf.toString();
    }

    public static Class getConfigBeanClass(String xPath) {
        String beanName = ConfigBeansFactory.getConfigBeanNameByXPath(xPath);
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.config.serverbeans." + beanName);
            return cl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getRuntimeModelBeanClass(String j2eeType) {
        try {
            return Class.forName("com.sun.enterprise.management.model." + j2eeType + "Mdl");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String descriptorToString(FeatureInfo descr) {
        return MBeanMetaHelper.descriptorToString(descr.getFields());
    }

    public static String descriptorToString(List fields) {
        String str = "Descriptor[";
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo field = (FieldInfo)fields.get(i);
            str = str + field.getName() + "=" + field.getValue() + " ";
        }
        return str + "]";
    }

    private static FieldInfo newField(String name, Object value) {
        FieldInfo info = new FieldInfo();
        info.setName(name);
        info.setValue(value);
        return info;
    }

    private static void addFieldToInfo(String name, String value, FeatureInfo info) {
        FieldInfo field = new FieldInfo();
        field.setName(name);
        field.setValue(value);
        info.addField(field);
    }

    private static void addDataToChildOperInfo(String childName, boolean bMulti, FeatureInfo info) {
        MBeanMetaHelper.addFieldToInfo("child", childName, info);
        if (bMulti) {
            MBeanMetaHelper.addFieldToInfo("multi", "true", info);
        }
    }

    public static String mapToMBeanAttributeName(String name) {
        if (name != null) {
            return name.replace('_', '-');
        }
        return name;
    }

    public static String mapToConfigBeanAttributeName(String name) {
        if (name != null) {
            return name.replace('_', '-');
        }
        return name;
    }

    public static String cutAttributeTokenFromXPath(String xpath) {
        int idx;
        if (!xpath.endsWith("]") && !xpath.endsWith("/") && (idx = xpath.lastIndexOf(47)) > 0 && xpath.length() > idx + 1 && xpath.charAt(idx + 1) == '@') {
            return xpath.substring(0, idx);
        }
        return xpath;
    }

    public static String getMultipleElementKeyValue(String xpath) {
        int idx;
        if (xpath.endsWith("']") && (idx = xpath.lastIndexOf(39, xpath.length() - 3)) > 0) {
            return xpath.substring(idx + 1, xpath.length() - 2);
        }
        return null;
    }

    public static String extractLastElemNameFromXPath(String xpath) {
        int idx;
        if (xpath.endsWith("]") && (idx = xpath.lastIndexOf(91)) > 0) {
            xpath = xpath.substring(0, idx);
        }
        if ((idx = xpath.lastIndexOf(47)) >= 0) {
            return xpath.substring(idx + 1);
        }
        return null;
    }

    public static String cutLastElementFromXPath(String xpath) {
        int idx;
        if (xpath.endsWith("]") && (idx = xpath.lastIndexOf(91)) > 0) {
            xpath = xpath.substring(0, idx);
        }
        if ((idx = xpath.lastIndexOf(47)) >= 0) {
            return xpath.substring(0, idx);
        }
        return null;
    }

    private static class AttrIntro {
        public String name = null;
        public String type = null;
        public String getName = null;
        public String setName = null;
        public String whereType = null;

        private AttrIntro() {
        }

        public AttributeInfo createAttributeInfo() {
            AttributeInfo ati = new AttributeInfo();
            ati.setName(this.name);
            ati.setType(this.type);
            if (this.setName != null) {
                ati.setWriteable(true);
                ati.addField(MBeanMetaHelper.newField("setter", this.setName));
            } else {
                ati.setWriteable(false);
            }
            if (this.getName != null) {
                ati.setReadable(true);
                ati.addField(MBeanMetaHelper.newField("getter", this.getName));
            } else {
                ati.setReadable(false);
            }
            if (this.whereType != null) {
                ati.addField(MBeanMetaHelper.newField("bean", this.whereType));
            }
            return ati;
        }

        public void mergeWithAttributeInfo(AttributeInfo ati) {
            ati.setType(this.type);
            if (this.setName == null) {
                ati.setWriteable(false);
            }
            if (this.getName == null) {
                ati.setReadable(false);
            }
        }
    }
}

