/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appverification.factory;

import com.sun.enterprise.appverification.factory.InstrumentLogger;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AppVerification {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private static boolean instrument_on = false;
    private static boolean redeploy = false;
    private static InstrumentLogger instrumentLogger;
    private static LocalStringManagerImpl localStrings;

    public static void redeploy(boolean hasRedeploy) {
        redeploy = hasRedeploy;
    }

    public static boolean hasRedeployed() {
        return redeploy;
    }

    public static void setInstrument(boolean on) {
        if (on && AppVerification.getInstrumentLogger() == null) {
            instrument_on = false;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.on.failed", "J2EE instrumentation implementation class NOT defined."));
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.off", "J2EE Application Verification is OFF..."));
            }
        } else {
            instrument_on = on;
            if (instrument_on && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.on", "J2EE Application Verification {0} is ON...", new Object[]{instrumentLogger.getVersion()}));
            }
        }
    }

    public static boolean doInstrument() {
        return instrument_on;
    }

    public static InstrumentLogger getInstrumentLogger() {
        if (instrumentLogger == null) {
            String name = null;
            Class<?> cls = null;
            try {
                name = System.getProperty("j2ee.instrument.logger", "com.sun.enterprise.appverification.tools.InstrumentLoggerImpl");
                cls = Class.forName(name);
                if (cls != null) {
                    instrumentLogger = (InstrumentLogger)cls.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                _logger.log(Level.SEVERE, "appverification.class_notfound", new Object[]{name});
            }
            catch (InstantiationException e) {
                _logger.log(Level.SEVERE, "appverification.class_instantiate_error", new Object[]{name});
            }
            catch (IllegalAccessException e) {
                _logger.log(Level.SEVERE, "appverification.class_access_error", new Object[]{name});
            }
        }
        return instrumentLogger;
    }

    static {
        localStrings = new LocalStringManagerImpl(AppVerification.class);
    }
}

