/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.backend.ClientJarMakerUtils;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;

class ApplicationClientJarMaker
implements ClientJarMaker {
    protected Properties props;

    public ApplicationClientJarMaker(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, null, target, stubs, props);
    }

    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive source2, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        ClientJarMakerUtils.populateStubs(target, stubs);
        if (!descriptor.isApplication()) {
            ClientJarMakerUtils.populateModuleJar(source, source2, target);
            return;
        }
        Application app = (Application)Application.class.cast(descriptor);
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)ModuleDescriptor.class.cast(modules.next());
            if (md.getModuleType().equals(ModuleType.WAR) || md.getModuleType().equals(ModuleType.RAR)) continue;
            AbstractArchive subSource = source.getEmbeddedArchive(md.getArchiveUri());
            AbstractArchive subSource2 = null;
            if (source2 != null) {
                subSource2 = source2.getEmbeddedArchive(md.getArchiveUri());
            }
            AbstractArchive subTarget = target.getEmbeddedArchive(md.getArchiveUri());
            ClientJarMakerUtils.populateModuleJar(subSource, subSource2, subTarget);
            target.closeEntry(subTarget);
            source.closeEntry(subSource);
            if (source2 != null) {
                source2.closeEntry(subSource2);
            }
            if (md.getAlternateDescriptor() == null) continue;
            String ddPath = md.getAlternateDescriptor();
            String runtimeDDPath = "sun-" + ddPath;
            if (source2 != null) {
                ClientJarMakerUtils.copy(source2, target, ddPath);
                ClientJarMakerUtils.copy(source2, target, runtimeDDPath);
                continue;
            }
            ClientJarMakerUtils.copy(source, target, ddPath);
            ClientJarMakerUtils.copy(source, target, runtimeDDPath);
        }
        List<String> libraries = ClientJarMakerUtils.getLibraryEntries(app, source);
        for (String library : libraries) {
            ClientJarMakerUtils.copy(source, target, library);
        }
        ClientJarMakerUtils.copyDeploymentDescriptors(new ApplicationArchivist(), source, source2, target);
    }
}

