/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.audit;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AuditModuleEvent;
import com.sun.enterprise.admin.event.AuditModuleEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import java.util.Properties;

public class AuditModuleEventListenerImpl
implements AuditModuleEventListener {
    public void auditModuleCreated(AuditModuleEvent event) throws AdminEventListenerException {
        try {
            String moduleName = event.getModuleName();
            AuditModule am = this.getAuditModule(moduleName, event.getConfigContext());
            String classname = am.getClassname();
            Properties props = this.getAuditModuleProperties(am);
            AuditManagerFactory.getInstance();
            AuditManager manager = AuditManagerFactory.getAuditManagerInstance();
            manager.addAuditModule(moduleName, classname, props);
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void auditModuleDeleted(AuditModuleEvent event) throws AdminEventListenerException {
        try {
            String moduleName = event.getModuleName();
            AuditManagerFactory.getInstance();
            AuditManager manager = AuditManagerFactory.getAuditManagerInstance();
            manager.removeAuditModule(moduleName);
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void auditModuleUpdated(AuditModuleEvent event) throws AdminEventListenerException {
        try {
            String moduleName = event.getModuleName();
            AuditModule am = this.getAuditModule(moduleName, event.getConfigContext());
            String classname = am.getClassname();
            Properties props = this.getAuditModuleProperties(am);
            AuditModule oldAm = this.getAuditModule(moduleName, event.getOldConfigContext());
            String oldClassname = oldAm.getClassname();
            Properties oldProps = this.getAuditModuleProperties(oldAm);
            AuditManagerFactory.getInstance();
            AuditManager manager = AuditManagerFactory.getAuditManagerInstance();
            if (!classname.equals(oldClassname)) {
                manager.addAuditModule(moduleName, classname, props);
            } else if (!props.equals(oldProps)) {
                com.sun.appserv.security.AuditModule auditModule = manager.getAuditModule(moduleName);
                auditModule.init(props);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    private AuditModule getAuditModule(String moduleName, ConfigContext configContext) throws ConfigException {
        SecurityService security = ServerBeansFactory.getSecurityServiceBean(configContext);
        return security.getAuditModuleByName(moduleName);
    }

    private Properties getAuditModuleProperties(AuditModule am) {
        ElementProperty[] elementProps = am.getElementProperty();
        int size = elementProps != null ? elementProps.length : 0;
        Properties props = new Properties();
        props.setProperty("name", am.getName());
        props.setProperty("classname", am.getClassname());
        for (int i = 0; i < size; ++i) {
            props.setProperty(elementProps[i].getName(), elementProps[i].getValue());
        }
        return props;
    }
}

