/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppVerifier {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    Method verify = null;
    Object verifier = null;

    public AppVerifier() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        String name = "com.sun.enterprise.tools.verifier.Verifier";
        try {
            Class<?> verifierClass = Class.forName(name);
            this.verify = verifierClass.getDeclaredMethod("verify", Application.class, AbstractArchive.class, List.class, File.class);
            Constructor<?> constructor = verifierClass.getDeclaredConstructor(new Class[0]);
            this.verifier = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.SEVERE, "verifier.class.notfound", new Object[]{name});
            throw e;
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.SEVERE, "verifier.method.notfound", e);
            throw e;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "verifier.intialization.error", e);
            throw e;
        }
    }

    public void verify(Application application, AbstractArchive abstractArchive, List classPath, File jspOutDir) throws Exception {
        Object result = this.verify.invoke(this.verifier, application, abstractArchive, classPath, jspOutDir);
        if ((Integer)result > 0) {
            throw new Exception("Some verifier tests Failed.");
        }
    }
}

