/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;

public class ModulesExistWeb
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneFailed = false;
            for (WebBundleDescriptor wbd : descriptor.getWebBundleDescriptors()) {
                if (wbd.getModuleDescriptor().getArchiveUri().equals("")) continue;
                ZipFile jarFile = null;
                InputStream deploymentEntry = null;
                boolean moduleDirExists = false;
                String archBase = this.getAbstractArchiveUri(descriptor);
                String moduleName = wbd.getModuleDescriptor().getArchiveUri();
                String moduleDir = FileUtils.makeFriendlyFileName(moduleName);
                File f = new File(archBase + File.separator + moduleDir);
                moduleDirExists = f.isDirectory();
                if (deploymentEntry != null || moduleDirExists) {
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "J2EE Web module [ {0} ] exists within [ {1} ].", new Object[]{wbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                } else {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: J2EE Web module [ {0} ] does not exist within [ {1} ].", new Object[]{wbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (deploymentEntry == null) continue;
                    deploymentEntry.close();
                }
                catch (Exception x) {}
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

