/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EntityManagerFactoryReference;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class EntityManagerFactoryWrapper
implements EntityManagerFactory,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EntityManagerFactoryWrapper.class);
    private String unitName;
    private transient EntityManagerFactory entityManagerFactory;

    public EntityManagerFactoryWrapper(EntityManagerFactoryReference referenceDescriptor) {
        this.unitName = referenceDescriptor.getUnitName();
    }

    private EntityManagerFactory getDelegate() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.unitName);
            if (this.entityManagerFactory == null) {
                throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
            }
        }
        return this.entityManagerFactory;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public void close() {
        this.getDelegate().close();
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    static EntityManagerFactory lookupEntityManagerFactory(String emfUnitName) {
        InvocationManager invMgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invMgr.getCurrentInvocation();
        EntityManagerFactory emf = null;
        if (inv != null) {
            Object descriptor = Switch.getSwitch().getDescriptorFor(inv.getContainerContext());
            emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory(inv.getInvocationType(), emfUnitName, descriptor);
        }
        return emf;
    }

    public static EntityManagerFactory lookupEntityManagerFactory(int invType, String emfUnitName, Object descriptor) {
        Set<EntityManagerFactory> emFactories;
        Application app = null;
        BundleDescriptor module = null;
        EntityManagerFactory emf = null;
        switch (invType) {
            case 1: {
                EjbDescriptor ejbDesc = (EjbDescriptor)descriptor;
                module = ejbDesc.getEjbBundleDescriptor();
                app = module.getApplication();
                break;
            }
            case 0: {
                module = (WebBundleDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
            case 2: {
                module = (ApplicationClientDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
        }
        if (module != null) {
            if (emfUnitName != null) {
                emf = module.getEntityManagerFactory(emfUnitName);
            } else {
                emFactories = module.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = emFactories.iterator().next();
                }
            }
        }
        if (app != null && emf == null) {
            if (emfUnitName != null) {
                emf = app.getEntityManagerFactory(emfUnitName, module);
            } else {
                emFactories = app.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = emFactories.iterator().next();
                }
            }
        }
        return emf;
    }
}

