/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.WebPipeline;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;

public class PESessionLockingStandardPipeline
extends WebPipeline {
    protected static Logger _logger = null;

    public PESessionLockingStandardPipeline(Container container) {
        super(container);
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.lockSession(request);
        try {
            super.invoke(request, response);
        }
        finally {
            this.unlockSession(request);
        }
    }

    protected Session getSession(Request request) {
        ServletRequest servletReq = request.getRequest();
        HttpServletRequest httpReq = (HttpServletRequest)servletReq;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SESSION_ID=" + id);
        }
        Manager mgr = this.getContainer().getManager();
        PersistentManagerBase pmb = (PersistentManagerBase)mgr;
        Session sess = null;
        try {
            sess = pmb.findSession(id);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETRIEVED_SESSION=" + sess);
        }
        return sess;
    }

    protected boolean lockSession(Request request) throws ServletException {
        boolean result = false;
        Session sess = this.getSession(request);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN LOCK_SESSION: sess =" + sess);
        }
        if (sess != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("locking session: sess =" + sess);
            }
            StandardSession haSess = (StandardSession)sess;
            while (keepTrying) {
                lockResult = haSess.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    result = true;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                _logger.warning("this should not happen-breaking background lock: sess =" + sess);
                haSess.unlockBackground();
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("finished locking session: sess =" + sess);
                _logger.finest("LOCK = " + haSess.getSessionLock());
            }
        }
        return result;
    }

    protected void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void unlockSession(Request request) {
        Session sess = this.getSession(request);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN UNLOCK_SESSION: sess = " + sess);
        }
        if (sess != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("unlocking session: sess =" + sess);
            }
            StandardSession haSess = (StandardSession)sess;
            haSess.unlockForeground();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("finished unlocking session: sess =" + sess);
                _logger.finest("LOCK = " + haSess.getSessionLock());
            }
        }
    }
}

