/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.VirtualServer;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;

public class VirtualServerPipeline
extends StandardPipeline {
    private static final StringManager sm = StringManager.getManager("com.sun.enterprise.web");
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private VirtualServer vs;
    private boolean isOff;
    private boolean isDisabled;
    private ArrayList<RedirectParameters> redirects;
    private ConcurrentLinkedQueue<CharChunk> locations;
    private ConcurrentLinkedQueue<UEncoder> urlEncoders;

    public VirtualServerPipeline(VirtualServer vs) {
        super(vs);
        this.vs = vs;
        this.locations = new ConcurrentLinkedQueue();
        this.urlEncoders = new ConcurrentLinkedQueue();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.isOff) {
            String msg = sm.getString("virtualServerValve.vsOff", this.vs.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(msg);
            }
            ((HttpServletResponse)response.getResponse()).sendError(404, msg);
        } else if (this.isDisabled) {
            String msg = sm.getString("virtualServerValve.vsDisabled", this.vs.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(msg);
            }
            ((HttpServletResponse)response.getResponse()).sendError(403, msg);
        } else {
            boolean redirect = false;
            if (this.redirects != null) {
                redirect = this.redirectIfNecessary(request, response);
            }
            if (!redirect) {
                this.doInvoke(request, response);
            }
        }
    }

    void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    void setIsOff(boolean isOff) {
        this.isOff = isOff;
    }

    void addRedirect(String from, String url, String urlPrefix, boolean escape) {
        if (this.redirects == null) {
            this.redirects = new ArrayList();
        }
        this.redirects.add(new RedirectParameters(from, url, urlPrefix, escape));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean redirectIfNecessary(Request request, Response response) throws IOException {
        block19: {
            String location;
            HttpServletResponse hres;
            block18: {
                if (this.redirects == null) {
                    return false;
                }
                HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                hres = (HttpServletResponse)request.getResponse();
                String requestURI = hreq.getRequestURI();
                RedirectParameters redirectMatch = null;
                int size = this.redirects.size();
                for (int i = 0; i < size; ++i) {
                    RedirectParameters elem = this.redirects.get(i);
                    if (!requestURI.startsWith(elem.from)) continue;
                    if (redirectMatch != null) {
                        if (elem.from.length() <= redirectMatch.from.length()) continue;
                        redirectMatch = elem;
                        continue;
                    }
                    redirectMatch = elem;
                }
                if (redirectMatch == null) break block19;
                location = null;
                String uriSuffix = requestURI.substring(redirectMatch.from.length());
                if ("/".equals(redirectMatch.from)) {
                    uriSuffix = "/" + uriSuffix;
                }
                location = redirectMatch.urlPrefix != null ? redirectMatch.urlPrefix + uriSuffix : redirectMatch.url;
                String queryString = hreq.getQueryString();
                if (queryString != null) {
                    location = location + queryString;
                }
                CharChunk locationCC = null;
                UEncoder urlEncoder = null;
                if (redirectMatch.isEscape) {
                    block17: {
                        try {
                            URL url = new URL(location);
                            locationCC = this.locations.poll();
                            if (locationCC == null) {
                                locationCC = new CharChunk();
                            }
                            locationCC.append(url.getProtocol());
                            locationCC.append("://");
                            locationCC.append(url.getHost());
                            if (url.getPort() != -1) {
                                locationCC.append(":");
                                locationCC.append(String.valueOf(url.getPort()));
                            }
                            if ((urlEncoder = this.urlEncoders.poll()) == null) {
                                urlEncoder = new UEncoder();
                                urlEncoder.addSafeCharacter('/');
                            }
                            locationCC.append(urlEncoder.encodeURL(url.getPath()));
                            location = locationCC.toString();
                            if (urlEncoder == null) break block17;
                            this.urlEncoders.offer(urlEncoder);
                        }
                        catch (MalformedURLException mue) {
                            logger.log(Level.WARNING, "virtualServerPipeline.invalidRedirectLocation", location);
                            break block18;
                        }
                        finally {
                            if (urlEncoder != null) {
                                this.urlEncoders.offer(urlEncoder);
                            }
                            if (locationCC != null) {
                                locationCC.recycle();
                                this.locations.offer(locationCC);
                            }
                        }
                    }
                    if (locationCC != null) {
                        locationCC.recycle();
                        this.locations.offer(locationCC);
                    }
                }
            }
            hres.sendRedirect(location);
            return true;
        }
        return false;
    }

    static class RedirectParameters {
        private String from;
        private String url;
        private String urlPrefix;
        private boolean isEscape;

        RedirectParameters(String from, String url, String urlPrefix, boolean isEscape) {
            this.from = from;
            this.url = url;
            this.urlPrefix = urlPrefix;
            this.isEscape = isEscape;
        }
    }
}

