/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.ctl.SortKey;
import java.io.IOException;

public final class SortControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.473";
    private static final long serialVersionUID = 8931633399436504556L;

    public SortControl(SortKey[] sortKeyArray, boolean bl) throws IOException {
        super(OID, bl, null);
        this.value = this.setEncodedValue(sortKeyArray);
    }

    public SortControl(String[] stringArray, boolean bl) throws IOException {
        super(OID, bl, null);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SortKey[] sortKeyArray = new SortKey[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sortKeyArray[i] = new SortKey(stringArray[i]);
        }
        this.value = this.setEncodedValue(sortKeyArray);
    }

    private byte[] setEncodedValue(SortKey[] sortKeyArray) throws IOException {
        BerEncoder berEncoder = new BerEncoder(32);
        berEncoder.beginSeq(48);
        for (int i = 0; i < sortKeyArray.length; ++i) {
            berEncoder.beginSeq(48);
            berEncoder.encodeString(sortKeyArray[i].getAttributeID(), true);
            String string = sortKeyArray[i].getMatchingRuleID();
            if (string != null) {
                berEncoder.encodeString(string, 128, true);
            }
            if (!sortKeyArray[i].isAscending()) {
                berEncoder.encodeBoolean(true, 129);
            }
            berEncoder.endSeq();
        }
        berEncoder.endSeq();
        return berEncoder.getTrimmedBuf();
    }
}

