/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.RbCbSelectorBase;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ConversionUtilities;
import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class RbCbSelector
extends RbCbSelectorBase
implements NamingContainer {
    public static final String IMAGE_FACET = "image";
    private static final String IMAGE_URL_PROP = "imageURL";
    private static final String URL_PROP = "url";
    private static final String ALT_PROP = "alt";
    public static final String LABEL_FACET = "label";
    private static final String LABEL_PROP = "label";
    private static final String TEXT_PROP = "text";
    private static final String LABEL_LEVEL_PROP = "labelLevel";
    private static final String TOOLTIP_PROP = "toolTip";
    private static final String VISIBLE_PROP = "visible";
    private static final String RENDERED_PROP = "rendered";
    private static final String ID_SEPARATOR = "_";
    private static final Boolean trueSelectedValue = Boolean.TRUE;

    protected void addToRequestMap(FacesContext context, String groupName) {
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String groupName = this.getName();
        if (groupName == null || !this.isValid() || !this.isChecked()) {
            return;
        }
        this.addToRequestMap(context, groupName);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
        }
        return this.getConvertedValue(context, this, submittedValue);
    }

    public Object getConvertedValue(FacesContext context, RbCbSelector component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            throw new ConverterException("The submitted value is null. The submitted value must be a String or String array.");
        }
        boolean isStringArray = submittedValue instanceof String[];
        boolean isString = submittedValue instanceof String;
        if (!isStringArray && !isString) {
            throw new ConverterException("The submitted value must be a String or String array.");
        }
        String rawValue = null;
        if (isStringArray) {
            if (((String[])submittedValue).length > 0) {
                rawValue = ((String[])submittedValue)[0];
            }
        } else if (isString) {
            rawValue = (String)submittedValue;
        }
        boolean unselected = rawValue == null || rawValue.length() == 0;
        Object newValue = null;
        Object selectedValue = this.getSelectedValue();
        if (unselected) {
            newValue = ConversionUtilities.convertRenderedValue(context, rawValue, (UIComponent)this);
            if (!ConversionUtilities.renderedNull((UIComponent)component) && selectedValue instanceof Boolean && newValue == null) {
                newValue = (Boolean)selectedValue != false ? Boolean.FALSE : Boolean.TRUE;
            }
            return this.getUnselectedValue(context, (UIComponent)component, newValue);
        }
        newValue = ConversionUtilities.convertValueToObject((UIComponent)component, rawValue, context);
        return newValue == rawValue ? selectedValue : newValue;
    }

    private Object getUnselectedValue(FacesContext context, UIComponent component, Object noValue) {
        ValueBinding valueBinding = component.getValueBinding("value");
        if (valueBinding == null) {
            return noValue;
        }
        Class clazz = valueBinding.getType(context);
        if (clazz == null) {
            return noValue;
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitiveUnselectedValue(clazz, noValue);
        }
        return noValue;
    }

    private Object getPrimitiveUnselectedValue(Class clazz, Object booleanUnselectedValue) {
        if (clazz.equals(Boolean.TYPE)) {
            return booleanUnselectedValue;
        }
        if (clazz.equals(Byte.TYPE)) {
            return new Integer(-128);
        }
        if (clazz.equals(Double.TYPE)) {
            return new Double(Double.MIN_VALUE);
        }
        if (clazz.equals(Float.TYPE)) {
            return new Float(Float.MIN_VALUE);
        }
        if (clazz.equals(Integer.TYPE)) {
            return new Integer(Integer.MIN_VALUE);
        }
        if (clazz.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        if (clazz.equals(Short.TYPE)) {
            return new Short(Short.MIN_VALUE);
        }
        return new Long(Long.MIN_VALUE);
    }

    public Object getSelectedValue() {
        Object sv = super.getSelectedValue();
        return sv == null ? trueSelectedValue : sv;
    }

    public boolean isChecked() {
        Object selectedValue = this.getSelectedValue();
        Object selected = this.getSelected();
        if (selectedValue == null || selected == null) {
            return false;
        }
        if (this.getValueBinding("selected") == null && selected instanceof String && selectedValue instanceof Boolean) {
            return selectedValue.equals(Boolean.valueOf((String)selected));
        }
        return selected.equals(selectedValue);
    }

    public UIComponent getImageComponent() {
        UIComponent imageComponent = this.getFacet(IMAGE_FACET);
        if (imageComponent != null) {
            return imageComponent;
        }
        return this.createImageComponent();
    }

    public UIComponent getLabelComponent() {
        UIComponent labelComponent = this.getFacet("label");
        if (labelComponent != null) {
            return labelComponent;
        }
        return this.createLabelComponent();
    }

    protected UIComponent createLabelComponent() {
        String label = this.getLabel();
        if (label == null) {
            return null;
        }
        Label flabel = new Label();
        if (flabel == null) {
            return null;
        }
        flabel.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, "label"));
        flabel.setLabeledComponent((UIComponent)this);
        flabel.setText(label);
        flabel.setLabelLevel(this.getLabelLevel());
        flabel.setToolTip(this.getToolTip());
        flabel.setParent((UIComponent)this);
        return flabel;
    }

    protected UIComponent createImageComponent() {
        String iurl = this.getImageURL();
        if (iurl == null) {
            return null;
        }
        ImageComponent image = new ImageComponent();
        image.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, IMAGE_FACET));
        image.setUrl(this.getImageURL());
        image.setToolTip(this.getToolTip());
        image.setAlt(this.getToolTip());
        image.setParent((UIComponent)this);
        return image;
    }
}

