/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.component.util.Util;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class HyperlinkRenderer
extends AbstractRenderer {
    private static final String[] booleanAttributes = new String[]{"disabled"};
    private static final String[] integerAttributes = new String[]{"tabIndex"};
    private static final String[] stringAttributes = new String[]{"onBlur", "onFocus", "onDblClick", "onKeyDown", "onKeyPress", "onMouseUp", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Hyperlink link = (Hyperlink)component;
        if (this.isSubmitLink(link)) {
            String paramId = component.getClientId(context) + "_submittedField";
            String value = (String)context.getExternalContext().getRequestParameterMap().get(paramId);
            if (value == null || !value.equals(component.getClientId(context))) {
                return;
            }
            link.queueEvent((FacesEvent)new ActionEvent((UIComponent)link));
            RenderingUtilities.setLastClientID(context, link.getPrimaryElementID(context));
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Hyperlink link = (Hyperlink)component;
        String label = link.getText();
        if (label != null) {
            writer.writeText((Object)label, null);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        this.renderLink(context, component, writer);
    }

    protected void renderLink(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Hyperlink link = (Hyperlink)component;
        if (!link.isDisabled()) {
            writer.startElement("a", (UIComponent)link);
        } else {
            writer.startElement("span", (UIComponent)link);
        }
        String label = link.getText();
        String url = link.getUrl();
        String target = link.getTarget();
        String tooltip = link.getToolTip();
        String onclick = link.getOnClick();
        String urlLang = link.getUrlLang();
        String sb = this.getStyles(context, (UIComponent)link);
        this.addCoreAttributes(context, component, writer, sb);
        this.addIntegerAttributes(context, component, writer, integerAttributes);
        HyperlinkRenderer.addStringAttributes(context, component, writer, stringAttributes);
        if (!link.isDisabled()) {
            this.addBooleanAttributes(context, component, writer, booleanAttributes);
            if (url != null) {
                if (url.startsWith("#") || url.startsWith("mailto:") || url.startsWith("javascript:")) {
                    writer.writeURIAttribute("href", (Object)url, "url");
                } else {
                    url = context.getApplication().getViewHandler().getResourceURL(context, url);
                    RenderingUtilities.renderURLAttribute(context, writer, component, "href", url, "url");
                }
                if (onclick != null) {
                    writer.writeAttribute("onclick", (Object)onclick, "onclick");
                }
            } else {
                UIComponent form = Util.getForm(context, component);
                if (form != null) {
                    String formClientId = form.getClientId(context);
                    StringBuffer buff = new StringBuffer(200);
                    if (onclick != null) {
                        buff.append(onclick);
                        if (!onclick.endsWith(";")) {
                            buff.append(";");
                        }
                    }
                    buff.append("return hyperlink_submit(this, ");
                    buff.append("'");
                    buff.append(formClientId);
                    buff.append("'");
                    buff.append(", ");
                    boolean didOnce = false;
                    Iterator kids = component.getChildren().iterator();
                    while (kids.hasNext()) {
                        UIComponent kid = (UIComponent)kids.next();
                        if (!(kid instanceof UIParameter)) continue;
                        if (!didOnce) {
                            buff.append("new Array(");
                        }
                        String name = (String)kid.getAttributes().get("name");
                        String value = (String)kid.getAttributes().get("value");
                        if (!didOnce) {
                            buff.append("'");
                        } else {
                            buff.append(",'");
                        }
                        buff.append(name);
                        buff.append("','");
                        buff.append(value);
                        buff.append("'");
                        didOnce = true;
                    }
                    if (!didOnce) {
                        buff.append("null");
                    } else {
                        buff.append(")");
                    }
                    buff.append(");");
                    writer.writeAttribute("onclick", (Object)buff.toString(), null);
                    writer.writeAttribute("href", (Object)"#", null);
                }
            }
            if (null != target) {
                writer.writeAttribute("target", (Object)target, null);
            }
            if (null != tooltip) {
                writer.writeAttribute("title", (Object)tooltip, null);
            }
            if (null != urlLang) {
                writer.writeAttribute("hreflang", (Object)urlLang, "urlLang");
            }
        }
        this.finishRenderAttributes(context, component, writer);
        this.renderChildren(context, component);
        if (!link.isDisabled()) {
            writer.endElement("a");
        } else {
            writer.endElement("span");
        }
    }

    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        super.encodeChildren(context, component);
    }

    protected String getStyles(FacesContext context, UIComponent component) {
        Hyperlink link = (Hyperlink)component;
        StringBuffer sb = new StringBuffer();
        Theme theme = ThemeUtilities.getTheme(context);
        if (link.isDisabled()) {
            sb.append(" ");
            sb.append(theme.getStyleClass("LINK_DISABLED"));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private boolean isSubmitLink(Hyperlink h) {
        return h.getUrl() == null;
    }
}

