/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cli;

import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.InteractiveInput;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLIParser
extends ArgsParser
implements InteractiveInput {
    private StringManager sm;
    private boolean interactiveInput = false;
    private Map interactiveInputMap;
    private String currentDomain;
    private int index = 0;
    private CommonInfoModel commonInfo;
    private ArgsParser parser;

    public CLIParser() {
        this(new CommonInfoModel(), new String[0]);
    }

    public CLIParser(CommonInfoModel cim, String[] args) {
        super(args, cim);
        this.commonInfo = cim;
        this.sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.cli");
        this.interactiveInputMap = this.parse(this);
        this.verifyCommonInfo(this.commonInfo);
        if (!this.commonInfo.isUpgradeSupported()) {
            this.getLogger().info(this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported") + this.commonInfo.getSourceVersionAndEdition() + " -> " + this.commonInfo.getTargetVersionAndEdition());
            System.exit(1);
        }
        this.commonInfo.enlistDomainsFromSource();
    }

    public void setCommonInfoModel(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfoModel getCommonInfoModel(CommonInfoModel commonInfo) {
        return commonInfo;
    }

    public void printInfo() {
        this.commonInfo.printInfo();
    }

    public Logger getLogger() {
        return LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }

    public void parseComandLineArguments(String[] args) {
        this.parser = new ArgsParser(args, this.commonInfo);
        this.interactiveInputMap = this.parser.parse(this);
        this.verifyCommonInfo(this.commonInfo);
        if (!this.commonInfo.isUpgradeSupported()) {
            this.getLogger().info(this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported") + this.commonInfo.getSourceVersionAndEdition() + " -> " + this.commonInfo.getTargetVersionAndEdition());
            System.exit(1);
        }
        this.commonInfo.enlistDomainsFromSource();
    }

    public void collectMissingArguments(Map inputMap) {
        Iterator itr;
        File biDir;
        byte[] b;
        if (inputMap.containsKey("noprompt")) {
            return;
        }
        List domainList = this.commonInfo.getDomainList();
        for (String domainName : domainList) {
            String suffix = "-" + domainName;
            if (inputMap.get("source") != null || inputMap.get("s") != null || inputMap.get("domain" + suffix) == null) continue;
            this.helpUsage();
            System.exit(1);
        }
        if (inputMap.get("source") == null && inputMap.get("s") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Source_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String sourceDir = new String(b, 0, c);
                String source = sourceDir.trim();
                biDir = new File(source + File.separator + "bin");
                if (!(!source.equals("") && biDir.isDirectory() || this.commonInfo.checkSourceInputAsDomainRoot(source))) {
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
                    this.helpUsage();
                    System.exit(1);
                }
                if (this.commonInfo.checkSourceInputAsDomainRoot(source)) {
                    this.commonInfo.setSourceDomainRoot(source);
                }
                this.commonInfo.setSourceInstallDir(source);
                inputMap.put("source", source);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (inputMap.get("target") == null && inputMap.get("t") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String targetDir = new String(b, 0, c);
                String target = targetDir.trim();
                biDir = new File(target + File.separator + "bin");
                if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).isValidTargetPath(target)) {
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
                    this.helpUsage();
                    System.exit(1);
                }
                this.commonInfo.setTargetDomainRoot(target);
                this.commonInfo.enlistDomainsFromSource();
                inputMap.put("target", target);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (inputMap.get("adminuser") == null && inputMap.get("a") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminuser_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String adminUser = new String(b, 0, c);
                String admiuser = adminUser.trim();
                this.commonInfo.setAdminUserName(admiuser);
                inputMap.put("adminuser", admiuser);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (inputMap.get("adminpassword") == null && inputMap.get("w") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminpassword_input"));
            b = new byte[1024];
            try {
                String adminPassword = new CliUtil().getPassword();
                this.commonInfo.setAdminPassword(adminPassword);
                inputMap.put("adminpassword", adminPassword);
                this.interactiveInput = true;
                if (this.commonInfo.getTargetVersionAndEdition().equals("as90pe")) {
                    this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), null);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (!this.commonInfo.getTargetVersionAndEdition().equals("as90pe") && inputMap.get("masterpassword") == null && inputMap.get("m") == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"));
            String password = new CliUtil().getPassword();
            this.commonInfo.setMasterPassword(password);
            inputMap.put("masterpassword", password);
            this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), password);
            this.interactiveInput = true;
        }
        if (inputMap.get("clinstancefiles") == null && inputMap.get("i") == null && this.commonInfo.checkUpgradefrom7xeeto9xee()) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.clinstance_input"));
            b = new byte[1024];
            try {
                String clinstance;
                String clinstancetrim;
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                if ((clinstancetrim = (clinstance = new String(b, 0, c)).trim()).length() > 2) {
                    StringTokenizer st = new StringTokenizer(clinstancetrim, ",");
                    Vector<Object> clinstanceList = new Vector<Object>();
                    while (st.hasMoreTokens()) {
                        clinstanceList.add(st.nextElement());
                    }
                    this.commonInfo.processClinstnceConfFiles(clinstanceList);
                }
                inputMap.put("clinstancefiles", clinstancetrim);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (this.commonInfo.isUpgradeJKStoJKS() && (inputMap.containsKey("jkspwdfile") || inputMap.containsKey("j"))) {
            if (inputMap.containsKey("capwdfile") || inputMap.containsKey("p")) {
                return;
            }
            this.helpUsage();
            System.exit(1);
        }
        if ((this.commonInfo.isUpgradeJKStoNSS() || this.commonInfo.isUpgradeNSStoJKS()) && (inputMap.containsKey("jkspwdfile") || inputMap.containsKey("j")) && (inputMap.containsKey("capwdfile") || inputMap.containsKey("p"))) {
            if (inputMap.containsKey("nsspwdfile") || inputMap.containsKey("n")) {
                return;
            }
            this.helpUsage();
            System.exit(1);
        }
        if (this.commonInfo.isUpgradeNSStoNSS() && (inputMap.containsKey("nsspwdfile") || inputMap.containsKey("n"))) {
            if (inputMap.containsKey("targetnsspwdfile") || inputMap.containsKey("e")) {
                return;
            }
            this.helpUsage();
            System.exit(1);
        }
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            List stdAloneInsts = UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping());
            itr = stdAloneInsts.iterator();
        } else {
            domainList = this.commonInfo.getDomainList();
            itr = domainList.iterator();
        }
        while (itr.hasNext()) {
            boolean validpwd;
            String password;
            String certOption;
            String certName;
            String suffix;
            String domainName;
            String instanceName = null;
            if (this.commonInfo.getSourceVersion().equals("7x")) {
                Vector instDInfo = (Vector)itr.next();
                instanceName = (String)instDInfo.elementAt(0);
                DomainInfo dInfo = (DomainInfo)instDInfo.elementAt(1);
                domainName = dInfo.getDomainName();
                suffix = "-" + domainName;
                certName = domainName + ":" + instanceName;
                certOption = "domain-" + certName;
            } else {
                domainName = (String)itr.next();
                suffix = "-" + domainName;
                certName = domainName;
                certOption = "domain" + suffix;
            }
            boolean certmigration = false;
            if (inputMap.get(certOption) == null) {
                String answer = "no";
                while (true) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Ask_domain_cert_migration", (Object)certName));
                    byte[] b2 = new byte[1024];
                    try {
                        String ans;
                        int c = System.in.read(b2);
                        if (c == -1) {
                            System.exit(1);
                        }
                        if (!(answer = (ans = new String(b2, 0, c)).trim()).equalsIgnoreCase("yes") && !answer.equalsIgnoreCase("y") && !answer.equalsIgnoreCase("no") && !answer.equalsIgnoreCase("n") && !answer.equalsIgnoreCase("")) continue;
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
                        continue;
                    }
                    break;
                }
                if (answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("y")) {
                    if (!this.commonInfo.getDomainList().contains(domainName)) {
                        this.helpUsage();
                        this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist", (Object)domainName));
                        System.exit(1);
                    }
                    this.commonInfo.setCurrentDomain(domainName);
                    this.commonInfo.addDomainOptionName(domainName);
                    inputMap.put("domain-" + this.commonInfo.getCurrentDomain(), domainName);
                    this.interactiveInput = true;
                    this.commonInfo.setCertificateConversionFlag(true);
                    certmigration = true;
                }
            } else {
                this.commonInfo.setCertificateConversionFlag(true);
                certmigration = true;
            }
            if (inputMap.get("nsspwd" + suffix) == null && certmigration && (this.commonInfo.isUpgradeNSStoJKS() || this.commonInfo.isUpgradeJKStoNSS() || this.commonInfo.isUpgradeNSStoNSS())) {
                if (this.commonInfo.isUpgradeJKStoNSS()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                } else {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.NSS_pwd_input"));
                }
                password = new CliUtil().getPassword();
                if (instanceName != null) {
                    this.commonInfo.setCertDbPassword(domainName, instanceName, password);
                } else {
                    this.commonInfo.setCertDbPassword(password);
                }
                boolean validpwd2 = PasswordVerifier.verifySourceNSSPassword(this.commonInfo);
                if (!validpwd2) {
                    this.commonInfo.recover();
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
                    System.exit(1);
                }
                inputMap.put("nsspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (inputMap.get("targetnsspwd" + suffix) == null && certmigration && this.commonInfo.isUpgradeNSStoNSS()) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                password = new CliUtil().getPassword();
                this.commonInfo.setTargetCertDbPassword(password);
                boolean validpwd3 = PasswordVerifier.verifyTargetNSSPassword(this.commonInfo, this.commonInfo.getTargetConfig());
                if (!validpwd3) {
                    this.commonInfo.recover();
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_target_nss_password"));
                    System.exit(1);
                }
                inputMap.put("targetnsspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (inputMap.get("jkspwd" + suffix) == null && certmigration && (this.commonInfo.isUpgradeJKStoJKS() || this.commonInfo.isUpgradeJKStoNSS() || this.commonInfo.isUpgradeNSStoJKS())) {
                if (this.commonInfo.isUpgradeNSStoJKS()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_JKS_input"));
                }
                if (this.commonInfo.isUpgradeJKStoNSS()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.JKS_input"));
                }
                if (this.commonInfo.isUpgradeJKStoJKS()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.JKS_password"));
                }
                password = new CliUtil().getPassword();
                this.commonInfo.setJksKeystorePassword(password);
                String jksPath = "";
                jksPath = this.commonInfo.isUpgradeNSStoJKS() ? this.commonInfo.getTargetJKSKeyStorePath() : this.commonInfo.getSourceJKSKeyStorePath();
                validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, password);
                if (!validpwd) {
                    this.commonInfo.recover();
                    this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                    System.exit(1);
                }
                inputMap.put("jkspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (inputMap.get("capwd" + suffix) != null || !certmigration || !this.commonInfo.isUpgradeJKStoJKS() && !this.commonInfo.isUpgradeJKStoNSS() && !this.commonInfo.isUpgradeNSStoJKS()) continue;
            if (this.commonInfo.isUpgradeNSStoJKS()) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_CA_input"));
            }
            if (this.commonInfo.isUpgradeJKStoNSS()) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.CA_input"));
            }
            if (this.commonInfo.isUpgradeJKStoJKS()) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.CA_password"));
            }
            password = new CliUtil().getPassword();
            this.commonInfo.setJksCAKeystorePassword(password);
            String trustJksPath = "";
            trustJksPath = this.commonInfo.isUpgradeNSStoJKS() ? this.commonInfo.getTargetTrustedJKSKeyStorePath() : this.commonInfo.getSourceTrustedJKSKeyStorePath();
            validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, password);
            if (!validpwd) {
                this.commonInfo.recover();
                this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                System.exit(1);
            }
            inputMap.put("capwd-" + domainName, password);
            this.interactiveInput = true;
        }
    }

    private void verifyUserAndPasswords(String adminUser, String adminPassword, String masterPassword) {
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).validateUserDetails(adminUser, adminPassword, masterPassword)) {
            if (!this.commonInfo.getTargetVersionAndEdition().equals("as90pe")) {
                this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
            } else {
                this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword"));
            }
            System.exit(1);
        }
    }

    public void verifyCommonInfo(CommonInfoModel commonInfo) {
        if (commonInfo.getSourceInstallDir().equals(commonInfo.getTargetInstallDir())) {
            String msg = this.sm.getString("enterprise.tools.upgrade.cli.Invalid_input_directory");
            this.helpUsage(msg);
            System.exit(1);
        }
        if (!(this.interactiveInputMap.containsKey("source") || this.interactiveInputMap.containsKey("s") && this.interactiveInputMap.containsKey("target") || this.interactiveInputMap.containsKey("t") && this.interactiveInputMap.containsKey("adminuser") || this.interactiveInputMap.containsKey("a") && this.interactiveInputMap.containsKey("adminpassword") || this.interactiveInputMap.containsKey("w"))) {
            this.helpUsage();
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        CLIParser parser = new CLIParser();
        parser.setCommonInfoModel(new CommonInfoModel());
        parser.parseComandLineArguments(args);
        parser.printInfo();
    }

    private String readPassword(String pwdfile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pwdfile)));
            String password = reader.readLine();
            if (password != null) {
                password = password.trim();
            } else {
                this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile));
                System.exit(1);
            }
            return password;
        }
        catch (FileNotFoundException fe) {
            this.helpUsage();
            this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.password_file_missing", (Object)pwdfile));
            System.exit(1);
        }
        catch (Exception io) {
            this.getLogger().severe(this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile));
            System.exit(1);
        }
        return null;
    }
}

