/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor.stats;

import com.sun.appserv.management.j2ee.statistics.MapStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.StatisticFactory;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.management.monitor.MonitoringStatsImplBase;
import com.sun.enterprise.management.monitor.stats.CustomStatsImpl;
import javax.management.InstanceNotFoundException;
import javax.management.j2ee.statistics.Statistic;

public abstract class CustomMonitoringStatsImplBase
extends MonitoringStatsImplBase {
    public CustomMonitoringStatsImplBase(String j2eeType) {
        super(j2eeType);
    }

    protected Statistic[] getStatisticsFromImpl(CustomStatsImpl customStatsImpl) {
        try {
            Statistic[] statistics = this.getStatisticsFromImplRaw(customStatsImpl);
            for (int i = 0; i < statistics.length; ++i) {
                Statistic origStatistic = statistics[i];
                MapStatisticImpl m = new MapStatisticImpl(origStatistic);
                String convertedName = this.originalToDerivedStatisticName(origStatistic.getName());
                if (!convertedName.equals(origStatistic.getName())) {
                    m.setName(convertedName);
                }
                Class<? extends Statistic> theClass = StatisticFactory.getInterface(origStatistic);
                assert (theClass != null);
                statistics[i] = StatisticFactory.create(theClass, m.asMap());
                assert (theClass.isAssignableFrom(statistics[i].getClass()));
            }
            return statistics;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            if (!(rootCause instanceof InstanceNotFoundException)) {
                this.logWarning("Can't get Statistics from impl of " + this.getObjectName() + "\n" + rootCause.getMessage() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            }
            throw new RuntimeException(e);
        }
    }

    protected Statistic[] getStatisticsFromImplRaw(CustomStatsImpl impl) {
        try {
            Statistic[] statistics = impl.getStatistics();
            return statistics;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.logWarning("CustomMonitoringStatsImplBase: the stats impl for the stats of AMX MBean " + this.getObjectName() + " threw an exception: " + rootCause + ", stack = \n" + ExceptionUtil.getStackTrace(rootCause));
            return new Statistic[0];
        }
    }
}

