/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.enterprise.management.support.UpDownInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class UploadInfo
extends UpDownInfo {
    private final String mName;
    private final long mTotalSize;
    private FileOutputStream mOutputStream;
    private long mWrittenSoFar;

    public UploadInfo(Object id, String name, long totalSize) throws IOException {
        super(id, UploadInfo.createTempFile(id, name, totalSize));
        this.mName = name;
        this.mTotalSize = totalSize;
        this.getFile().createNewFile();
        this.getFile().deleteOnExit();
        this.mOutputStream = new FileOutputStream(this.getFile());
        this.mWrittenSoFar = 0L;
    }

    private static File createTempFile(Object id, String name, long totalSize) throws IOException {
        String tempName = name != null ? name : id + "_" + totalSize;
        File actual = new File(tempName);
        if (actual.exists()) {
            actual = File.createTempFile(tempName, null);
        }
        return actual;
    }

    public boolean isDone() {
        return this.mWrittenSoFar == this.mTotalSize;
    }

    public boolean write(byte[] bytes) throws IOException {
        if (this.isDone() || this.mWrittenSoFar + (long)bytes.length > this.mTotalSize) {
            throw new IllegalArgumentException("too many bytes");
        }
        this.getOutputStream().write(bytes);
        this.mWrittenSoFar += (long)bytes.length;
        if (this.isDone()) {
            this.mOutputStream.close();
            this.mOutputStream = null;
        }
        this.accessed();
        return this.isDone();
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public void cleanup() throws IOException {
        if (this.mOutputStream != null) {
            this.mOutputStream.close();
        }
        this.getFile().delete();
    }

    private FileOutputStream getOutputStream() {
        return this.mOutputStream;
    }
}

