/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MetadataAccessor {
    protected String m_mappedBy = "";
    protected Class m_targetEntity;
    protected ArrayList<String> m_cascadeTypes;

    protected RelationshipAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        this.setIsOptional(false);
        this.m_targetEntity = Void.TYPE;
        this.setFetchType("LAZY");
        this.m_cascadeTypes = new ArrayList();
    }

    public void addCascadeType(String cascadeType) {
        this.m_cascadeTypes.add(cascadeType);
    }

    public ArrayList<String> getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    protected MetadataJoinColumns getJoinColumns() {
        JoinColumn joinColumn = (JoinColumn)this.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)this.getAnnotation(JoinColumns.class);
        return new MetadataJoinColumns(joinColumns, joinColumn);
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    protected DatabaseMapping getOwningMapping() {
        String ownerAttributeName = this.m_mappedBy;
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(ownerAttributeName);
        if (mapping == null) {
            this.m_validator.throwNoMappedByAttributeFound(ownerDescriptor.getJavaClass(), ownerAttributeName, this.getJavaClass(), this.getAttributeName());
        }
        return mapping;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public boolean hasJoinColumn() {
        return this.isAnnotationPresent(JoinColumn.class);
    }

    public boolean hasJoinColumns() {
        return this.isAnnotationPresent(JoinColumns.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class) || this.isAnnotationPresent(PrimaryKeyJoinColumn.class);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && this.hasPrimaryKeyJoinColumns();
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        for (String cascadeType : this.getCascadeTypes()) {
            this.setCascadeType(cascadeType, mapping);
        }
        if (this.m_descriptor.isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType(CascadeType.PERSIST.name(), mapping);
        }
    }

    protected List<MetadataJoinColumn> processJoinColumns() {
        if (this.m_descriptor.hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.m_descriptor.getAssociationOverrideFor(this.getAttributeName()), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor());
    }

    protected List<MetadataJoinColumn> processJoinColumns(MetadataJoinColumns joinColumns, MetadataDescriptor descriptor) {
        if (descriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                this.m_validator.throwIncompleteJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
            for (MetadataJoinColumn joinColumn : joinColumns.values()) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                this.m_validator.throwIncompleteJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
        } else if (joinColumns.size() > 1) {
            this.m_validator.throwExcessiveJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
        }
        return joinColumns.values();
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.m_descriptor.hasMappingForAttributeName(this.getAttributeName())) {
                this.m_logger.logWarningMessage(MetadataLogger.IGNORE_MAPPING, this);
            } else {
                if (this.hasColumn()) {
                    this.m_validator.throwRelationshipHasColumnSpecified(this.getJavaClass(), this.getAttributeName());
                }
                if (this.getTargetEntity() != ValueHolderInterface.class && (this.getTargetEntity() != Void.TYPE || this.getReferenceClass() != ValueHolderInterface.class)) {
                    this.process();
                }
            }
            this.setIsProcessed();
        }
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals("cascade-all") || type.equals(CascadeType.ALL.name())) {
            mapping.setCascadeAll(true);
        } else if (type.equals("cascade-merge") || type.equals(CascadeType.MERGE.name())) {
            mapping.setCascadeMerge(true);
        } else if (type.equals("cascade-persist") || type.equals(CascadeType.PERSIST.name())) {
            mapping.setCascadePersist(true);
        } else if (type.equals("cascade-refresh") || type.equals(CascadeType.REFRESH.name())) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals("cascade-remove") || type.equals(CascadeType.REMOVE.name())) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(CascadeType[] cascadeTypes) {
        for (CascadeType cascadeType : cascadeTypes) {
            this.addCascadeType(cascadeType.name());
        }
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setReferenceClass(Class potentialReferenceClass, String context) {
        if (potentialReferenceClass == Void.TYPE) {
            this.getLogger().logConfigMessage(context, this.getAnnotatedElement(), (Object)this.getReferenceClass());
        } else {
            this.m_accessibleObject.setReferenceClass(potentialReferenceClass);
        }
    }

    public void setTargetEntity(Class targetEntity) {
        this.m_targetEntity = targetEntity;
    }
}

